collection The catalog defines a collection as a collection of ordered items, each item being a set of <attribute, value> pairs. In our XML representation, this is directly translated as a list of dictionaries. The keys in each dictionary correspond to the attributes in the collection.

As an example, the cumulative constraint is defined in the catalog as cumulative(TASKS; LIMIT) where TASKS is a collection(origin–dvar; duration–dvar; end–dvar; height–dvar) and LIMIT is an int. For each task, height must be defined but only two attributes among origin, duration and end can be defined (since by definition origin-end=duration).

A constraint that enforces a maximal height of 4 for 3 tasks starting at origins represented as a CSP variable and with given duration and height, can be represented by:
<constraint name="C1" arity="3" scope="X2 X5 X9" reference="global:cumulative">
<parameters>
[
{/origin X2 /duration 10 /height 1} {/origin X5 /duration 5 /height 2}
{/origin X9 /duration 8 /height 3}
] 4
</parameters>
</contraint>
Note that attributes that are not required are represented as missing keys in the dictionaries.

Assuming the conventional order origin, duration, end, height is defined for cumulative, this constraint can also be written as
<constraint name="C1" arity="3" scope="X2 X5 X9" reference="global:cumulative">
<parameters>
[
{X2 10 <nil/> 1} {X5 5 <nil/> 2}
{X9 8 <nil/> 3}
]
4
</parameters>
</contraint>
Here, missing attributes are represented by the <nil/> element.

For each global constraint, the conventional order of dictionaries is the order of attributes defined in the global catalog.

When a global constraint has a collection parameter which contains only one attribute, it is represented as a list of values. For example, the global cardinality constraint has a first parameter of type collection of dvar. It is represented directly a list of variables ([X1 X2 X3]) instead of a list of dictionaries with one single key ([{/var X1} {/var X2} {/var X3}] or, using conventional order, [{X1} {X2} {X3}]).