Arguments of a global constraint in the catalog must be translated in XML
as a sequence of elements inside the tag <parameters> in the order defined in the catalog.

Below, we present the description of some translations of global constraints from the catalog. Note that most of the global constraints from the catalog can be automatically translated in format XCSP 2.1.

Constraint allDifferent It is defined in the catalog as follows:
alldifferent(VARIABLES)
VARIABLES collection(var:dvar)
Following rules given above, we may have in XML:
<constraint name="C1" arity="4" scope="V1 V2 V3 V4" reference="global:allDifferent">
<parameters>
[ V1 V2 V3 V4 ]
</parameters>
</constraint>
Note that it is also possible to include integer constants. For example:
<constraint name="C1" arity="4" scope="V1 V2 V3 V4" reference="global:allDifferent">
<parameters>
[ V1 V2 100 V3 V4 ]
</parameters>
</constraint>
Note that the old syntax, with implicit parameters, is deprecated. On the other hand, this constraint can be represented in intension by introducing a predicate that represents a conjunction of inequalities. It can also be converted into a clique of binary notEqual constraints. For more information about this constraint, see e.g. [13, 17, 2].

Constraint among It is defined in the catalog as follows:
among(NVAR,VARIABLES,VALUES) NVAR dvar VARIABLES collection(var:dvar)
VALUES collection(val:int)
Following rules given above, as an illustration, we can have in XML:
<constraint name="C1" arity="5" scope="V0 V1 V2 V3 V4" reference="global:among">
<parameters>
V0 [ V1 V2 V3 V4 ]
[ 1 5 8 10 ]
</parameters>
</constraint>