
## 4 Representing Qcsp Instances 32

All the relevant information on quantification in included in a new section called "quantification" (see below).

## 4.2 Quantification

This section gives the quantification structure associated with a QCSP/QCSP+
instance. It essentially provides an ordered list of quantification blocks, called blocks. The size of this list is mandatorily declared in the attribute nbBlocks:
<quantification nbBlocks="b">
put here a sequence of b blocks
</quantification>
Notice that the order in which quantification blocks are listed inside this XML element provides key information, as it specifies the left-to-right order of
(restricted) quantifications associated with the QCSP/QCSP+ instance. Each block of a QCSP/QCSP+ instance is represented by the following XML element:

<block quantifier = 'put here the quantifier type' scope = 'put here a list of variable names'>
put here an optional list of constraints (QCSP+ only)
</block> where

- the value of the attribute quantifier must be either "exists" or "forall".

It gives the kind of quantification of all the variables in this block;
- the value of the attribute *scope* specifies the variables which are quantified in this block. At least one variable must be present. The order in which variables are listed is not relevant;
- for QCSP instances, the body of a block element must be empty
- for QCSP+ instances, the body of the block element may contain one or more <constraint> elements that restrict the quantification of the block to the sole values of the quantified variables which satisfy all constraints defined in the body of the <block> element.

Such constraints may only refer to variables defined in the same block and to variables defined in previous blocks (w.r.t. to the order in the enclosing <quantification> element), but not to variables mentioned in later blocks; Notice the following features of well-formed QCSP/QCSP+ instances:
1. each variable can be mentioned in *at most one* block; 2. each variable must be mentioned in *at least* one block; this means the problem is *closed*, i.e. no free variables are allowed2; 2This restriction may be relaxed by future formalizations of open QCSPs.