
## 5.2 Relations

For WCSP represented in extension, it is necessary to introduce "soft" relations.

These relations are defined as follows:
- the value of the attribute semantics is set to "soft".

- weighted tuples are given as described in Section 2.11

- an new attribute defaultCost is mandatory and represents the cost of any tuple which is not explicitly listed in the relation. Its value belongs to [0*, . . . , k*] where k is the maximal cost of the valuation structure, defined by the attribute maximalCost of the element <constraints> (see below).

Note that it may be the special value 'infinity'.

## 5.3 Functions

Instead of representing constraints of a WCSP in extension, it is possible to represent them in intension by introducing cost functions. For any tuple passed to such a function, its cost is computed and returned. In other words, we employ here exactly the same mechanism as the one employed for hard constraints represented in intension. The only difference is that a predicate returns a Boolean value whereas a cost function must return an integer value.

If present, the XML element called <functions> admits an attribute which is called nbFunctions and contains some occurrences (at least, one) of an element called <function>, one for each function associated with at least a constraint of the instance. The attribute nbFunctions is of type integer and its value is equal to the number of occurrences of the element <function>. The
<functions> element must be a direct child of the <instance> element.

Each element <function> admits two attributes, called name and return, and contains two elements, called <parameters> and <expression>. It is defined as follows:

```
<function name = 'put here the name of the function' return='return type'>
 <parameters>
    put here a list of formal parameters
 </parameters>
 <expression>
    Put here one (or several) representation(s) of the function expression
 </expression>
</function>

```

The attribute name corresponds to the name of the function and its value must be a valid identifier.

The attribute return indicates the return type of the function. In this version of the format, the only return type used is 'int'. Then elements <parameters>
and <expression> are defined exactly as those defined for <predicate> elements. The only difference is that the expression must be of type integer instead of being of type Boolean.