
## 1 Introduction

The Constraint Programming (CP) community suffers from the lack of a standardized representation of problem instances. This is the reason why we propose an XML representation of constraint networks. The Extensible Markup Language (XML) [18] is a simple and flexible text format playing an increasingly important role in the exchange of a wide variety of data on the Web. The objective of the XML representation is to ease the effort required to test and compare different algorithms by providing a common test-bed of constraint satisfaction instances.

One should notice that the proposed representation is low-level. More precisely, for each instance, domains, variables, relations (if any), predicates (if any) and constraints are exhaustively defined. The current format should not be confused with powerful modelling language such as the high-level proposals dedicated to mathematical programming - e.g. AMPL (http://www.ampl.com)
and GAMS (http://www.gams.com) - or dedicated to constraint programming1
- e.g. OPL [10], EaCL [16], NCL [19], ESRA [8], Zinc [6] and ESSENCE [9].

Nevertheless, we also project to extend this format in a near future to take into account higher level constructs.

In this document, we present an extension, denoted XCSP 2.1, of the format XCSP 2.0 which was used for the 2006 CSP solver competition. It aims at being a (hopefully good) compromise between readability, verbosity and structuration. More precisely, our objective is that the representation be:

- readable: thanks to XML, we think that it is the case. If you want to modify an instance by hand, you can do it without too many difficulties whereas it would be almost impossible with a tabular format. Only a few constructions require an a-priori knowledge of the format.

- concise: with the abridged version which doesn't use systematically XML
tags and attributes, the proposed representation can be comparable in length to one that would be given in tabular format. This is important, for example, to represent instances involving constraints in extension.

- structured: because the format is based on XML, it remains rather easy to parse instances.
Roughly speaking, we propose two variants of this format:
- a fully-tagged representation,

## - An Abridged Representation.

The first representation (tagged notation) is a full XML, completely structured representation which is suitable for using generic XML tools but is more verbose and more tedious to write for a human being. The second representation (abridged notation) is just a shorthand notation of the first representation 1Remark that the specification language Z (http://vl.users.org) has also been used to build nice (high-level) problem models [15]