which is easier to read and write for a human being, but less suitable for generic XML tools.

These two representations are equivalent and this document details the translation of one representation to another. Automatic tools to convert from one representation to another will be made available, and parsers will accept the two representations. This will allow human beings to use the shorthand notation to encode an instance while still being able to use generic XML tools.

## 2 Basic Components

This section describes how the most common kinds of information are represented in this XML format. This section only details the general data structures that are used in the description of instances. The way these structures are used to represent an instance is presented in the other sections of this document. As mentioned in the introduction, we present two representations for each structure. The first one is fully-tagged and the second one is abridged.

## 2.1 Identifiers And Integers

First, let us introduce the syntax of identifiers and integers. An identifier has to be associated with some XML elements, usually under the form of an attribute called *name*. An identifier must be a valid identifier according to the most common rules (start with a letter or underscore and further contain letters, digits or underscores). More precisely, identifiers and integers are defined (in BNF notation) as follows:
<identifier> ::= <letter> | "_" { <letter> | <digit> | "_" }
<integer> ::= [ "+" | "-"] <digit> {<digit>} <letter> ::= "a".."z" | "A".."Z"
<digit> ::= "0".."9" Of course, identifiers are case-sensitive.

## 2.2 Separators 2.2.1 Tagged Notation

For the tagged version, we do not need to use any specific separator since the document is fully structured.

## 2.2.2 Abridged Notation

For the abridged version, we sometimes need to employ separators. They are defined as follows:
<whitespace> ::= " " | "\t" | "\n" | "\r"
<separator> ::= <whitespace> | { <whitespace> }