
## 2.3 Constants

Different kinds of constant can be used in the encoding of a CSP instance.

## 2.3.1 Tagged Notation

Boolean constants are written using two special elements: <true/> and <false/>. Integer constants are written inside a <i> element (e.g. <i>19</i>).

Real constants are written inside a <r> element (e.g. <r>19.5</r>).

## 2.3.2 Abridged Notation

Wherever it is legal to have a numerical constant, its value can be written directly without the enclosing tag (e.g. 19, 19.5). 19 is considered as an integer constant.

To avoid introducing reserved keywords, Boolean constants (<true/> and
<false/>) cannot be abridged.

## 2.4 Intervals 2.4.1 Tagged Notation

Intervals are represented by a <interval> element with two attributes: min and max. The min represents the minimal value of the interval (the lower bound) and the max attribute the maximal value (the upper bound). For example,
<interval min="10" max="13"/> corresponds to the set {10, 11, 12, 13}.

## 2.4.2 Abridged Notation

To represent an interval, on has just to write two constants (of the same type)
separated by the sequence "..". For example, 10..13 corresponds to the set of integers {10, 11, 12, 13}.

## 2.5 Variables

Several constructs in the format have to reference variables. For simplicity, we consider here that the term variable refers to both effective and formal parameters of functions and predicates.

## 2.5.1 Tagged Notation

The reference to a variable is represented by a <var> element with an empty body and a single attribute name which provides the identifier of the variable. For example, a reference to the variable X1 is represented by <var name="X1"/>.