
## 2.5.2 Abridged Notation

Wherever it is legal to have a <var name="*identifier* "/> element, this element can be replaced equivalently by *identifier* . For example, X1 and <var name="X1"/> are two legal and equivalent ways to refer to the variable X1.

## 2.6 Formal Parameters

A predicate or function in this XML format must first define the list of its formal parameters (with their type). Then, these formal parameters can be referenced with the notations defined in section 2.5.

In both tagged and abridged representations, formal parameters are defined in the body of a <parameters> element.

## 2.6.1 Tagged Notation

In the tagged notation, each formal parameter is defined by a <parameter>
element with two attributes. The attribute name defines the formal name of the parameter and the attribute type defines its type. For example, <parameter name="X0" type="int"> defines a parameter named X0 of integer type.

## 2.6.2 Abridged Notation

Wherever it is legal to have a <parameter> element, a formal parameter can be written in abridged notation by its type followed by whitespace followed by the parameter name (as in C and Java programming language). Consecutive parameters must be separated by whitespace. For example, int X0 is the abridged representation of <parameter name="X0" type="int">.

The syntax of the formal parameters list is described by the following grammar (in BNF notation):
<formalParameters> ::= [<formalParametersList>]
<formalParametersList> ::= <formalParameter>
| <formalParameter> <separator> <formalParametersList>
<formalParameter> ::= <type> <separator> <identifier>
<type> ::= "int"

## 2.7 Lists

A list is an array of (possibly heterogeneous) objects. The order of objects in the list is significant (but this order may be deliberately ignored when needed).

## 2.7.1 Tagged Notation

A list is represented by a <list> element with all members of the list given in the body of the element. For example, a list containing the integers 1, 2 and the Boolean value *true* is represented by:
<list> <i>1</i> <i>2</i> <true/> </list>