
## 2.7.2 Abridged Notation

Wherever it is legal to have a list element, the opening square brace is defined as a synonym of <list> and the closing square brace is defined as a synonym of </list>. A separator is used between two elements of the list. Whitespace can be found before and after a square brace.

[1 2 <true/>]

## 2.8 Matrices

Vectors are represented as lists, 2-dimensions matrices are represented as lists of vectors, 3-dimensions matrices are represented as lists of 2-dimensions matrices and so on. To improve readability, 2-dimensions matrices are represented as lists of lines of coefficients. [1 2 3]

[

![0_image_0.png](0_image_0.png)

![0_image_1.png](0_image_1.png)

]

## 2.9 Dictionaries

A dictionary is an associative array that maps a key to a value. In other words, it is an array of <key,value> pairs. A key is a name which references a value in the data structure. A notation common to a number of languages to access the value corresponding to a key k in a dictionary d is d[k]. In a sense, a dictionary is a generalization of an array: indices in (classical) arrays must be contiguous integers while keys in a dictionary can be arbitrary names. A dictionary can also be seen as a generalization of the notion of structures (struct in C/C++) and records (Pascal). A record with n fields f1*, . . . , f*n can be seen as a dictionary containing the n keys f1*, . . . , f*n and the corresponding values. A dictionary is an extension of a record since new keys can be added to a dictionary while a record usually has a fixed list of fields. Each pair <key,value> in a dictionary is called an entry in that dictionary.

A function which accepts a dictionary as parameter can decide that some keys must be present in the dictionary and that some others keys are optional.

This provides a simple way to support optional parameters. When a key is missing in a dictionary, it is considered that there is no corresponding value.

The special tag <nil/> is another way to specify explicitly that a key has no corresponding value. This special value corresponds to the null value in SQL.

Omitting a key k from a dictionary or defining that key k corresponds to value
<nil/> are equivalent ways of associating no value to key k.