The order of keys in a dictionary is not significant. A dictionary may contain no key at all. A dictionary can be associated to a key in a given dictionary (in other words, dictionaries may be contained in a dictionary).

## 2.9.1 Tagged Notation

An entry of a dictionary that associates a value v with key k is encoded by an element <entry> with a single attribute key with value k and a body containing the value v: <entry key="k">v</entry>
A dictionary is defined by a <dict> element with all entries of the dictionary given inside the body: <dict><entry key="name1">value1</entry> <entry key="name2">value2</entry></dict>. The body of this element cannot contain other elements than dictionary entries.

## 2.9.2 Abridged Notation

Several notations are already used in different languages to associate a key with a value in an associative array (key => value in PHP and Perl, /key value in PostScript and PDF,...). Since the character > is a reserved character in XML,
we use the PostScript notation.

A dictionary in abridged notation starts by a opening curly brace followed by a list of entries and is ended by a closing curly brace. Each entry is written as a key immediately preceded by a slash (no space between the slash and the key), whitespace and the value corresponding to this key. Whitespace can be found before and after a curly brace. For example:
{/name1 value2 /name2 value2}

## 2.9.3 Conventional Order

In some cases (e.g. when a function expects a dictionary with a given set of keys),
a conventional order can be associated with a dictionary. This conventional order specifies a default order of keys which can be used to further shorten the notations. When the conventional order of keys can be known from the context, a dictionary can be written in abridged notation by opening a curly brace, listing the values of each key which is expected in the dictionary and closing the curly brace. The absence of a slash following the opening curly brace identifies a dictionary represented in conventional order (note however that white space is allowed between the opening curly brace and the first slash).

In this context, there must be as many values inside the curly braces as the number of keys in the conventional order. To assign no value to a given key, the special value <nil/> must be used.

For example, the coordinates of a point of a plane may be represented by a dictionary containing two keys x and y. The point at coordinates (2, 5) can be represented by several notations. We can have: <dict>
<entry key="x"><i>2</i></entry>