# Learning Dtw Global Constraint For Time Series Classification Vit Niennattrakul G49Vnn@Cp.Eng.Chula.Ac.Th Chotirat Ann Ratanamahatana Ann@Cp.Eng.Chula.Ac.Th

Department of Computer Engineering, Chulalongkorn University Phayathai Rd, Pathumwan, Bangkok 10330 Thailand
+66 (0)2 218 6956

## Abstract

1-Nearest Neighbor with the Dynamic Time Warping (DTW)
distance is one of the most effective classifiers on time series domain. Since the global constraint has been introduced in speech community, many global constraint models have been proposed including Sakoe-Chiba (S-C) band, Itakura Parallelogram, and Ratanamahatana-Keogh (R-K) band. The R-K band is a general global constraint model that can represent any global constraints with arbitrary shape and size effectively. However, we need a good learning algorithm to discover the most suitable set of R-K bands, and the current R-K band learning algorithm still suffers from an 'overfitting' phenomenon. In this paper, we propose two new learning algorithms, i.e., band boundary extraction algorithm and iterative learning algorithm. The band boundary extraction is calculated from the bound of all possible warping paths in each class, and the iterative learning is adjusted from the original R-K band learning. We also use a Silhouette index, a well-known clustering validation technique, as a heuristic function, and the lower bound function, LB Keogh, to enhance the prediction speed. Twenty datasets, from the Workshop and Challenge on Time Series Classification, held in conjunction of the SIGKDD 2007, are used to evaluate our approach.

## Categories And Subject Descriptors H.2.8 [**Database Management**]: Data Mining

General Terms Algorithms, Performance, Experimentation Keywords Time Series, Classification, Dynamic Time Warping

## 1. Introduction

Classification problem is one of the most important tasks in time series data mining. A well-known 1-Nearest Neighbor
(1-NN) with Dynamic Time Warping (DTW) distance is one of the best classifier to classify time series data, among other approaches, such as Support Vector Machine (SVM)
[9], Artificial Neural Network (ANN) [3], and Decision Tree [6]. For the 1-NN classification, selecting an appropriate distance measure is very crucial; however, the selection criteria still depends largely on the nature of data itself, especially in time series data. Though the Euclidean distance is commonly used to measure the dissimilarity between two time series, it has been shown that DTW distance is more appropriate and produces more accurate results. Sakoe-Chiba Band (S-C Band) [8] originally speeds up the DTW calculation and later has been introduced to be used as a DTW
global constraint. In addition, the S-C Band was first implemented for the speech community, and the width of the global constraint was fixed to be 10% of time series length.

However, recent work [5] reveals that the classification accuracy depends solely on this global constraint; the size of the constraint depends on the properties of the data at hands.

To determine a suitable size, all possible widths of the global constraint are tested, and the band with the maximum training accuracy is selected.

Ratanamahatana-Keogh Band (R-K Band) [4] has been introduced to generalize the global constraint model represented by a one-dimensional array. The size of the array and the maximum constraint value is limited to the length of the time series. And the main feature of the R-K band is the multi bands, where each band is representing each class of data. Unlike the single S-C band, this multi R-K
bands can be adjusted as needed according to its own class' warping path.

Although the R-K band allows great flexibility to adjust the global constraint, a learning algorithm is needed to discover the 'best' multi R-K bands. In the original work of R-K Band, a hill climbing search algorithm with two heuristic functions (accuracy and distance metrics) is proposed.

The search algorithm climbs though a space by trying to increase/decrease specific parts of the bands until terminal conditions are met. However, this learning algorithm still suffers from an 'overfitting' phenomenon since an accuracy metric is used as a heuristic function to guide the search.