To solve this problem, we propose two new learning algorithms, i.e., band boundary extraction and iterative learning. The band boundary extraction method first obtains a maximum, mean, and mode of the path's positions on the DTW distance matrix, and the iterative learning, band's structures are adjusted in each round of the iteration to a Silhouette Index [7]. We run both algorithms and the band that gives better results. In prediction step, the 1-NN using Dynamic Time Warping distance with this discovered band is used to classify unlabeled data. Note that a lower bound, LB Keogh [2], is also used to speed up our 1-NN
classification. The rest of this paper is organized as follows. Section 2 gives some important background for our proposed work. In Section 3, we introduce our approach, the two novel learning algorithms. Section 4 contains an experimental evaluation including some examples of each dataset. Finally, we conclude this paper in Section 5.

## 2. Background

Our novel learning algorithms are based on four major fundamental concepts, i.e., Dynamic Time Warping (DTW)
distance, Sakoe-Chiba band (S-C band), RatanamahatanaKeogh band (R-K band), and Silhouette index, which are briefly described in the following sections.

## 2.1 Dynamic Time Warping Distance Dynamic Time Warping (Dtw) [5] Distance Is A Well-Known

similarity measure based on shape. It uses a dynamic programming technique to find all possible warping paths, and selects the one with the minimum distance between two time series. To calculate the distance, it first creates a distance matrix, where each element in the matrix is a cumulative distance of the minimum of three surrounding neighbors.

Suppose we have two time series, a sequence Q of length n (Q = q1, q2, . . . , qi**, . . . , q**n) and a sequence C of length m (C = c1, c2, . . . , cj **, . . . , c**m). First, we create an n-by-m matrix, where every (**i, j**) element of the matrix is the cumulative distance of the distance at (**i, j**) and the minimum of three neighboring elements, where 1 ≤ i ≤ n and 1 ≤ j ≤ m. We can define the (**i, j**) element, γi,j , of the matrix as:

$$\gamma_{i,j}=d_{i,j}+\min\left\{\gamma_{i-1,j},\gamma_{i,j-1},\gamma_{i-1,j-1}\right\}$$

where di,j = (ci − qj )
2is the squared distance of qi and cj , and γi,j is the summation of di,j and the the minimum cumulative distance of three elements surrounding the (**i, j**)
element. Then, to find an optimal path, we choose the path that yields a minimum cumulative distance at (**n, m**), which is defined as:

$$D_{D T W}(Q,C)=\operatorname*{min}_{\forall w\in P}\left\{{\sqrt{\sum_{k=1}^{K}d_{w_{k}}}}\right.\qquad\qquad(2)$$

where P is a set of all possible warping paths, wk is (**i, j**) at k th element of a warping path, and K is the length of the warping path.

![0_image_0.png](0_image_0.png)

![0_image_1.png](0_image_1.png)

In reality, DTW may not give the best mapping according to our need because it will try its best to find the minimum distance. It may generate the unwanted path. For example, in Figure 1 [5], without global constraint, DTW will find its optimal mapping between the two time series. However, in many cases, this is probably not what we intend, when the two time series are expected to be of different classes. We can resolve this problem by limiting the permissible warping paths using a global constraint. Two well-known global constraints, Sakoe-Chiba band and Itakura Parallelogram [1],
and a recent representation, Ratanamahatana-Keogh band
(R-K band), have been proposed, Figure 2 [4] shows an example for each type of the constraints.

## 2.2 Sakoe-Chiba Band

Sakoe-Chiba band (S-C band), shown in Figure 2 (b), is one of the simplest and most popular global constraints, originally introduced to be used for speech community. The width of this global constraint is generally set to be 10% of the time series length. However, recent work [5] has shown that the different sizes of the band can be used towards a more accurate classification. We therefore need to test all possible widths of the global constraint so that the best width could be discovered. An evaluation function is needed to justify the selection. We commonly use accuracy metric