Table 4: Our classification approach.

![0_image_0.png](0_image_0.png)

9 endif
Table 5: Data preprocessing step.

Function [NewT, NewP , NewL] = PreProcess[T, P , L, **threshold**]
1 alpha**= complexity(**T, L); 2 set NewT = T, NewP = P , and **NewL** = L; 3 while (**alpha > threshold**) 4 NewL = NewL **/ 2;**
5 NewT = interpolate(NewT, **NewL**);
6 NewP = interpolate(NewP , **NewL**);
7 alpha = complexity(NewT, **NewL**);
8 endwhile m data points in length, we can calculate the complexity by the following equation.

## Complexity(**N, M**) = Log(N

$\log(n^2\times m^2)$. 
where a logarithm function is added to bring down the value to a more manageable range for users.

To decrease the complexity, we could reduce the length of each individual time series by using typical interpolation function. The new length of time series is set to be the current length divided by two. We keep reducing the time series length until the complexity is smaller than the user's defined threshold. Table 5 shows the preprocessing steps on a set of training data T, a set of unlabeled data P, the original length L, and the complexity threshold. In this work, we set this threshold value to 9, according to resources and the time constraint for this 24-hour Workshop and Challenge on Time Series Classification.

## 3.2 Boundary Band Extraction

Since the multi R-K band model allows a learning algorithm to create a different band for each different class. This boundary band extraction algorithm is derived from a simple intuition for each of the same-class data, we first calculate all their DTW distances, save all the warping paths, and plot those paths on a matrix (called a path matrix). After that, we will determine an appropriate R-K band. For each ri of this R-K band, the ri value is set to be the maximum between height above the diagonal in y direction and width to the right of the diagonal in x direction in the path matrix. We repeat these steps to every possible class in the

Table 6: Boundary Band Extraction Algorithm.

Function [best band, best heuristic] = **BandExtraction**[T]

![0_image_1.png](0_image_1.png)

dataset; we call this R-K band a **MaxBand**. Similarly, the band extraction is performed using mean average and mode instead of the maximum, resulting in a **MeanBand** and a ModeBand, respectively. Figure 4 illustrates the steps in creating a **MaxBand**. From these calculations, three multiple R-K bands are generated. The evaluation function is used to select the best band to be returned as an output of this algorithm. Table 6 shows the band boundary extraction algorithm on a set of training data T and return the best R-K band and the best heuristic value.

## 3.3 Finding The Best Warping Window In This Step, We Try To Achieve The Best Warping Window Of Sakoe-Chiba Band To Be An Input Of Our Proposed Iterative R-K Band Learning. This Function Is Slightly Different

![0_image_2.png](0_image_2.png)

Figure 4: The illustration of MaxBand calculation.

(a) finding all possible warping paths, (b) plotting all paths in a path matrix, and (c) calculating maximum value for each ri