where i ∈ [1..n**]. We have to be careful how we implement such a decomposition in a**
constraint solver. First, some solvers will not achieve HC on such constraints (see Sec 5.5 for more details). Second, we need an efficient algorithm to be able **to propagate the** decomposition in linear time. As we explain in more detail in Sec 5.5, a constraint solver could easily take quadratic time if it is not incremental.

We first show that this decomposition prevents us from propagating the Roots constraint completely. However, this is to be expected as propagating Roots **completely is**
NP-hard and this decomposition is linear to propagate. In addition, as we later show, in many circumstances met in practice, the decomposition does not in fact hinder propagation.

Theorem 4 HC on Roots([X1, .., Xn], S, T ) **is strictly stronger than HC on** i ∈ S →
Xi ∈ T , and Xi ∈ T → i ∈ S for all i ∈ [1..n]. Proof. Consider X1 ∈ {1, 2}, X2 ∈ {3, 4}, X3 ∈ {1, 3}, X4 ∈ {2, 3}, lb(S) = ub(S) = {3, 4}, lb(T ) = ∅, and ub(T ) = {1, 2, 3, 4}**. The decomposition is HC. However, enforcing**
HC on Roots **will prune 3 from** D(X2). ✷
In fact, enforcing HC on the decomposition achieves a level of consistency between BC and HC on the original Roots constraint. Consider X1 ∈ {1, 2, 3}, X2 ∈ {1, 2, 3}, lb(S) = ub(S) = {1, 2}, lb(T ) = {}, and ub(T ) = {1, 3}. The Roots **constraint is BC.**
However, enforcing HC on the decomposition will remove 2 from the domains of X1 and X2**. In the next section, we identify exactly when the decomposition achieves HC on**
Roots.

## 5.3 Some Special Cases

Many of the counting and occurrence constraints do not use the Roots **constraint in its**
more general form, but have some restrictions on the variables S, T or Xi**'s. For example,**
it is often the case that T or S **are ground. We select four important cases that cover**
many of these uses of Roots and show that enforcing HC on Roots **is then tractable.**
C1. ∀i ∈ lb(S), D(Xi) ⊆ lb(T ) C2. ∀i /∈ ub(S), D(Xi) ∩ ub(T ) = ∅
C3. X1, .., Xn **are ground**
C4. T **is ground**
We will show that in any of these cases, we can achieve HC on Roots **simply by propagating the decomposition.**
Theorem 5 If one of the conditions C1 to C4 **holds, then enforcing HC on** i ∈ S →
Xi ∈ T , and Xi ∈ T → i ∈ S for all i ∈ [1..n] achieves HC on Roots([X1, .., Xn]**, S, T** ).

Proof. **Our proof will exploit the following properties that are guaranteed to hold when** we have enforced HC on the decomposition.