Enforcing HC on this decomposition is polynomial. Decomposition thus offers a simple and promising method to propagate a Disjoint **constraint. Not surprisingly, the decomposition hinders propagation (otherwise we would have a polynomial algorithm for**
a NP-hard problem).

Theorem 10 GAC on Disjoint **is stronger than HC on the decomposition.**
Proof: Consider X1, Y1 ∈ {1, 2}, X2, Y2 ∈ {1, 3}, Y3 ∈ {2, 3} and {} ⊆ S, T ⊆ {1, 2, 3}.

Then Range([X1, X2], {1, 2}, S) and Range([Y1, Y2, Y3], {1, 2, 3}, T **) are HC, and** S∩T = {} is BC. However, enforcing GAC on Disjoint([X1, X2], [Y1, Y2, Y3**]) prunes 3 from** X2 and 1 from both Y1 and Y2. ✷

## 6.1.3 Number Of Values

The NValue **constraint is useful in a wide range of problems involving resources since**
it counts the number of distinct values used by a sequence of variables [22, 8, 7]. As we saw in Section 3, NValue([X1, .., Xn], N) holds iff N = |{Xi| 1 ≤ i ≤ n}|**. The**
AllDifferent constraint is a special case of the NValue **constraint in which** N = n. Unfortunately, it is NP-hard in general to enforce GAC on a NValue **constraint [13].**
However, there is an O(n log(n**)) algorithm to enforce a level of consistency similar to BC**
[3]. An alternative and even simpler way to implement this constraint is with a **Range**
constraint:
NValue([X1, .., Xn], N**) iff**
Range([X1, .., Xn], {1, .., n}, T ) ∧ |T | = N
HC on this decomposition is incomparable to BC on the NValue **constraint.**
Theorem 11 BC on NValue **is incomparable to HC on the decomposition.**
Proof: Consider X1, X2 ∈ {1, 2}, X3 ∈ {1, 2, 3, 4}, N ∈ {3} and {} ⊆ T ⊆ {1, 2, 3, 4}.

Then Range([X1, X2, X3], {1, 2, 3}, T ) and |T | = N **are both HC. However, enforcing**
BC on NValue([X1, X2, X3], N**) prunes 1 and 2 from** X3.

Consider X1, X2, X3 ∈ {1, 3} and N ∈ {3}. Then NValue([X1, X2, X3], N**) is BC.**
However, enforcing HC on Range([X1, X2, X3], {1, 2, 3}, T ) makes {} ⊆ T ⊆ {1, 3} **which**
will cause |T | **= 3 to fail.** ✷

## 6.1.4 Uses

In [5], propagation algorithms achieving GAC and BC are proposed for the **UsedBy**
constraint. UsedBy([X1, .., Xn], [Y1, .., Ym]) holds iff the multiset **of values assigned to**
Y1, .., Ym is a subset of the multiset of values assigned to X1, .., Xn**. We now introduce a**
variant of the UsedBy constraint called the Uses constraint. Uses([X1, .., Xn], [Y1**, .., Y**m])
holds iff the set of values assigned to Y1, .., Ym is a subset of the set **of values assigned to**
X1, .., Xn. That is, UsedBy **takes into account the number of times a value is used while**
Uses does not. Unlike the UsedBy constraint, enforcing GAC on Uses **is NP-hard.**
Theorem 12 Enforcing GAC on Uses **is NP-hard.**