
## 1 Introduction

Global constraints are central to the success of constraint programming [28]. Global constraints allow users to specify patterns that occur in many problems, and to exploit efficient and effective propagation algorithms for pruning the search space. Two common types of global constraints are counting and occurrence constraints. Occurrence constraints place restrictions on the occurrences of particular values. For instance, we may wish to ensure that no value used by one set of variables occurs **in a second set.**
Counting constraints, on the other hand, restrict the number of **values or variables meeting some condition. For example, we may want to limit the number of distinct values**
assigned to a set of variables. Many different counting and occurrences constraints have been proposed to help model a wide range of problems, especially those involving resources (see, for example, [25, 4, 26, 3, 5]).

In this paper, we will show that many such constraints can be specified by means of two new global constraints, Range and Roots **together with some standard elementary**
constraints like subset and set cardinality. These two new global constraints capture the familiar notions of image and domain **of a function. Understanding such notions** does not require a strong background in constraint programming. **A basic mathematical** background is sufficient to understand these constraints and use **them to specify other**
global constraints. We will show, for example, that Range and Roots **are versatile**
enough to allow specification of open **global constraints, a recent kind of global constraints** for which the set of variables involved is not known in advance.

Specifications made with Range and Roots **constraints are executable. We show**
that efficient propagators can be designed for the Range and Roots **constraints. We give** an efficient algorithm for propagating the Range **constraint based on a flow algorithm.** We also prove that it is intractable to propagate the Roots **constraint completely. We** therefore propose a decomposition of the Roots **constraint that can propagate it partially** in linear time. This decomposition does not destroy the global nature of the **Roots**
constraint as in many situations met in practice, it prunes all possible **values. The** proposed propagators can easily be incorporated into a constraint toolkit.

We show that specifying a global constraint using Range and Roots **provides us with**
an reasonable **method to propagate counting and occurrence constraints. There are three**
possible situations. In the first, the global nature of the Range and Roots **constraints**
is enough to capture the global nature of the given counting or occurrence constraint, and propagation is not hindered. In the second situation, completely propagating the counting or occurrence constraint is NP-hard. We must accept some loss of propagation if propagation is to be tractable. Using Range and Roots **is then one means to**
propagate the counting or occurrence constraint partially. In the third situation, the global constraint can be propagated completely in polynomial time but using **Roots** and Range **hinders propagation. In this case, if we want to achieve full propagation, we**
need to develop a specialised propagation algorithm.

We also show that decomposing occurrence constraints and counting constraints using the Range and Roots **constraints performs well in practice. Our experiments on random**
CSPs and a on real world problem from CSPLib demonstrate that propagating counting and occurrence constraints using the Range and Roots **constraints leads to a small loss**
in performance when compared to specialised global constraints and is competitive with 2