Proof: As sets are represented by their bounds, HC on the decomposition **cannot prune**
more on the Oj than BC does on the Gcc. To show strictness, consider X1, X2 ∈ {1, 2},
X3 ∈ {1, 2, 3}, di = i and O1, O2, O3 ∈ {0, 1}. The decomposition is HC (with **{} ⊆** S1, S2 ⊆ {1, 2, 3} and {} ⊆ S3 ⊆ {3}). However, enforcing GAC on the Xi **and BC on**
the Oj of the Gcc constraint will prune 1 and 2 from X3 and 0 from O1, O2 and O3. ✷
This illustrates another global constraint for which it is worth developing a specialised propagation algorithm.

## 6.2.2 Among

The Among constraint was introduced in CHIP to help model resource allocation **problems like car sequencing [4]. It counts the number of variables using values from a given**
set. Among([X1, .., Xn], [d1, .., dm], N) holds iff N = |{i | Xi ∈ {d1, .., dm}}|.

An alternative way to propagate the Among **constraint is to decompose it using a**
Roots **constraint:**
Among([X1, .., Xn], [d1, .., dm], N**) iff**
Roots([X1, .., Xn], S, {d1, .., dm}) ∧ |S| = N
It is polynomial to enforce HC on this case of the Roots **constraint since the target**
set is ground. This decomposition also does not hinder propagation. **It is therefore a**
potentially attractive method to implement the Among **constraint.** Theorem 15 GAC on Among is equivalent to HC on the decomposition using **Roots**.

Proof: Suppose the decomposition into Roots([X1, .., Xn], S, {d1, .., dm}**) and** |S| = N
is HC. The variables Xi **divide into three categories: those whose domain only contains**
elements from {d1, .., dm} (at most min(N**) such variables); those whose domain do not** contain any such elements (at most n−max(N**) such vars); those whose domain contains**
both elements from this set and from outside. Consider any value for a variable Xi**in the**
first such category. To construct support for this value, we assign the remaining variables in the first category with values from {d1, .., dm}**. If the total number of assigned values**
is less than min(N**), we assign a sufficient number of variables from the second category**
with values from {d1, .., dm} to bring up the count to min(N**). We then assign all the** remaining unassigned Xj with values outside {d1, .., dm}. Finally, we assign min(N**) to**
N**. Support can be constructed for variables in the other two categories in a similar way,**
as well as for any value of N between min(N**) and max(**N). ✷

## 6.2.3 At Most And At Least

The AtMost and AtLeast constraints are closely related. The AtMost **constraint puts** an upper bound on the number of variables using a particular value, whilst the **AtLeast**
puts a lower bound. For instance, AtMost([X1, .., Xn], d, N) holds iff |{i | Xi = d**}| ≤** N.

Both AtMost and AtLeast can be decomposed into Roots **constraints. For example:**
AtMost([X1, .., Xn], d, N**) iff**
Roots([X1, .., Xn], S, {d}) ∧ |S| ≤ N