Again it is polynomial to enforce HC on these cases of the Roots **constraint, and the**
decomposition does not hinder propagation. Decomposition is therefore also a potential method to implement the AtMost and AtLeast **constraints in case we do not have**
such constraints available in our constraint toolkit.

Theorem 16 GAC on AtMost is equivalent to HC on the decomposition. Roots([X1, .., Xn]**, S,** {d})
and on |S| ≤ N.

GAC on AtLeast is equivalent to HC on the decomposition. Roots([X1, .., Xn]**, S,** {d})
and on |S| ≥ N.

Proof: **The proof of the last theorem can be easily adapted to these two constraints.** ✷

## 6.3 Applications Of Range And Roots **Constraints**

Some global constraints need both Range and Roots **constraints in their specifications.**

## 6.3.1 Assign And Number Of Values

In bin packing and knapsack problems, we may wish to assign both a value and a bin to each item, and place constraints on the values appearing in each bin. **For instance, in the** steel mill slab design problem (prob038 in CSPLib), we assign colours and slabs to orders so that there are a limited number of colours on each slab. Assign&NValues([X1, .., Xn], [Y1, .., Yn], N)
holds iff |{Yi| Xi = j}| ≤ N for each j **[2]. We cannot expect to enforce GAC on such a**
constraint as it is NP-hard to do so in general.

Theorem 17 Enforcing GAC on Assign&NValues **is NP-hard.**
Proof: Deciding if the constraint AtMostNValue **has a solution is NP-complete, where**
AtMostNValue([Y1, .., Yn], N) holds iff |{Yi| 1 ≤ i ≤ n}| ≤ N **[8, 7]. The problem of**
the existence of a solution in this constraint is equivalent to the problem of the existence of a solution in Assign&NValues([X1, .., Xn], [Y1, .., Yn], N) where D(Xi) = {0}, ∀i ∈ 1..n.

Deciding whether Assign&NValues **is thus NP-complete and enforcing GAC is NPhard.** ✷
Assign&NValues can be decomposed into a set of Range and Roots **constraints:**
Assign&NValues([X1, .., Xn], [Y1, .., Yn], N**) iff**
∀j . Roots([X1, .., Xn], Sj , {j}) ∧
Range([Y1, .., Yn], Sj , Tj) ∧ |Tj | ≤ N
However, this decomposition hinders propagation.

Theorem 18 GAC on Assign&NValues **is stronger than HC on the decomposition.**
Proof: Consider N = 1, X1, X2 ∈ {0}, Y1 ∈ {1, 2}, Y2 ∈ {2, 3}. HC on the decomposition enforces S0 = {1, 2} and {} ⊆ T0 ⊆ {1, 2, 3} but no pruning on the Xi and Yj .

However, enforcing GAC on Assign&NValues([X1, X2], [Y1, Y2], N**) prunes 1 from** Y1 and 3 from Y2. ✷