alternative decompositions into more elementary constraints.

The rest of the paper is organised as follows. Section 2 gives the formal background.

Section 3 defines the Range and Roots **constraints and gives a couple of examples**
to illustrate how global constraints can be decomposed using these **two constraints. In**
Section 4, we propose a polynomial algorithm for the Range **constraint. In Section 5, we** give a complete theoretical analysis of the Roots **constraint and our decomposition of it,**
and we discuss implementation details. Section 6 gives many examples of counting and occurrence constraints that can be specified using the Range and Roots **constraints.**
Experimental results are presented in Section 7. Finally, we end with **conclusions in** Section 8.

## 2 Formal Background

A constraint satisfaction problem consists of a set of variables, each with a finite domain of values, and a set of constraints specifying allowed combinations of values for subsets of variables. We use capitals for variables (e.g. X, Y and S**), and lower case for values (e.g.** v and w). We write D(X) for the domain of a variable X**. A solution is an assignment of** values to the variables satisfying the constraints. A variable is ground **when it is assigned** a value. We consider both integer and set variables. A set variable S **is often represented** by its lower bound lb(S**) which contains the definite elements (that must belong to the** set) and an upper bound ub(S**) which also contains the potential elements (that may or** may not belong to the set).

Constraint solvers typically explore partial assignments enforcing **a local consistency**
property using either specialised or general purpose propagation **algorithms. Given a** constraint C, a bound support on C **is a tuple that assigns to each integer variable a** value between its minimum and maximum, and to each set variable a set between its lower and upper bounds which satisfies C**. A bound support in which each integer** variable is assigned a value in its domain is called a hybrid support. If C **involves only** integer variables, a hybrid support is a support**. A value (resp. set of values) for an** integer variable (resp. set variable) is bound or hybrid consistent with C **iff there exists** a bound or hybrid support assigning this value (resp. set of values) **to this variable. A**
constraint C is bound consistent (BC) iff for each integer variable Xi**, its minimum and**
maximum values belong to a bound support, and for each set variable Sj **, the values in** ub(Sj) belong to Sj in at least one bound support and the values in lb(Sj **) are those from**
ub(Sj) that belong to Sj in all bound supports. A constraint C is **hybrid consistent** (HC) iff for each integer variable Xi, every value in D(Xi**) belongs to a hybrid support, and**
for each set variable Sj , the values in ub(Sj ) belong to Sj **in at least one hybrid support,** and the values in lb(Sj) are those from ub(Sj) that belong to Sj **in all hybrid supports.**
A constraint C involving only integer variables is generalised arc consistent (GAC**) iff**
for each variable Xi, every value in D(Xi**) belongs to a support. If all variables in** C
are integer variables, hybrid consistency reduces to generalised arc consistency, and if all variables in C **are set variables, hybrid consistency reduces to bound consistency.**
To illustrate these different concepts, consider the constraint C(X1, X2, T **) that holds**
iff the set variable T is assigned exactly the values used by the integer variables X1 and X2. Let D(X1) = {1, 3}, D(X2) = {2, 4}, lb(T ) = {2} and ub(T ) = {1, 2, 3, 4}**. BC**