mapping onto particular values. These two constraints capture the notion of image and domain of a function, making them easy to understand to the non expert in constraint programming. We have shown that these two constraints can easily **specify counting** and occurrence constraints. For example, the open versions of some well-known global constraints can be specified with Range and Roots**. Beyond counting and occurrence** constraints, we have shown that the expressive power of Range and Roots **allows them**
to specify many other constraints.

We have proposed propagation algorithms for these two constraints. Hence, any global constraint specified using Range and Roots **can be propagated. In some cases,**
this gives a propagation algorithm which achieves GAC on the original global constraint
(e.g. the Permutation and Among **constraints). In other cases, this propagation**
algorithm may not make the original constraint GAC, but achieving GAC is NP-hard
(e.g. the NValue and Common **constraints). Decomposition is then one method to**
obtain a polynomial algorithm. In the remaining cases, the propagation algorithm may not make the constraint GAC, although specialised propagation algorithms can do so in polynomial time (e.g. the SymAllDiff **constraint). Our method can still be attractive**
in this last case as it provides a generic means of propagation for counting and occurrence constraints when specialised algorithms have not yet been proposed or are not available in the constraint toolkit.

We have presented a comprehensive study of the Range **constraint. We proposed an**
algorithm for enforcing hybrid consistency on Range. We also have presented a comprehensive study of the Roots **constraint. We proved that propagating completely the**
Roots **constraint is intractable in general. We therefore proposed a decomposition to** propagate it partially. This decomposition achieves hybrid consistency on the **Roots**
constraint under some simple conditions often met in practice. In addition, enforcing bound consistency on the decomposition achieves bound consistency on the Roots **constraint whatever conditions hold.**
Our experiments show the benefit we can obtain by incorporating the Range **and the**
Roots constraints in a constraint toolkit. First, despite being intractable, the **Roots**
constraint can be propagated using the decomposition we presented. Even if this decomposition hinders propagation in theory, our experiments show that it is seldom the case in practice. Second, in the absence of specialised propagation algorithms, **Range**
and Roots **appear to be a simple and a reasonable method for propagating (possibly**
intractable) global constraints that is competitive to other decompositions into more elementary constraints. Our experiments show that sometimes we do better than these other decompositions either in terms of pruning or in solution time or both (like the case of the decomposition of the Uses **constraint). In addition, compared to highly specialised** propagation algorithms like those for the AllDifferent and Gcc **constraints in Ilog** Solver, the loss in performance when using Range and Roots **was not great. Thus,** if the constraint toolkit lacks a specialised propagation algorithm, Range and **Roots**
offer a quick, easy, and acceptable way of propagation. Finally, we observed that the extra set variables introduced in Range and Roots **decompositions can be exploited**
in the design of new branching strategies. These extra set variables may provide both a modelling and solving advantage to the user. We hope that by presenting these results, developers of the many different constraint toolkits will be encouraged to include the Range and Roots **constraints into their solvers.**