NValue([X1, .., Xn], N**) iff**
Range([X1, .., Xn], {1, .., n}, T ) ∧ |T | = N
The AtMost constraint is one of the oldest global constraints [32]. The **AtMost**
constraint puts an upper bound on the number of variables using a particular value.

AtMost([X1, .., Xn], d, N) holds iff |{i | Xi = d}| ≤ N**. It can be decomposed using a**
Roots **constraint.**
AtMost([X1, .., Xn], d, N**) iff**
Roots([X1, .., Xn], S, {d}) ∧ |S| ≤ N
These two examples show that it can be quite simple to decompose global constraints using Range and Roots**. As we will show later, some other global constraints will**
require the use of both Range and Roots **in the same decomposition. The next sections** show how Range and Roots **can be propagated efficiently.**

## 4 Propagating The Range **Constraint**

Enforcing hybrid consistency on the Range **constraint is polynomial. This can be done**
using a maximum network flow problem. In fact, the Range constraint can be decomposed using a global cardinality constraint (Gcc**) for which propagators based on flow**
problems already exist [26, 24]. But the Range **constraint does not need the whole**
power of maximum network flow problems, and thus HC can be enforced on it at a lower cost than that of calling a Gcc **propagator. In this section, we propose an efficient way**
to enforce HC on Range**. To simplify the presentation, the use of the flow is limited to** a constraint that performs only part of the work needed for enforcing HC on **Range**.

This constraint, that we name Occurs([X1, . . . , Xn], T **), ensures that all the values in**
the set variable T **are used by the integer variables** X1 to Xn:
Occurs([X1, . . . , Xn], T ) iff T ⊆ X({1..n}) (that is, T ⊆ {Xi| i ∈ 1..n})
We first present an algorithm for achieving HC on Occurs **(Section 4.1), and then**
use this to propagate the Range **constraint (Section 4.2).**

## 4.1 Hybrid Consistency On **Occurs**

We achieve HC on Occurs([X1, . . . , Xn], T **) using a network flow.**

## 4.1.1 Building The Network Flow

We use a unit capacity network [1] in which capacities between two nodes can only be 0 or 1. This is represented by a directed graph where an arc from node x to node y **means that** a maximum flow of 1 is allowed between x and y **while the absence of an arc means that**