According to Table 2, this classic DSm rule of combination looks very expensive in terms of computations and memory size due to the huge number of elements in DΘ when the cardinality of Θ increases. This remark is however valid only if the cores (the set of focal elements of gbba) K1(m1) and K2(m2) coincide with DΘ,
i.e. when m1(A) > 0 and m2(A) > 0 for all A 6= ∅ ∈ DΘ. Fortunately, it is important to note here that in most of the practical applications the sizes of K1(m1) and K2(m2) are much smaller than |DΘ| because bodies of evidence generally allocate their basic belief assignments only over a subset of the hyper-power set. This makes things easier for the implementation of the classic DSm rule (4). The DSm rule is actually very easy to implement. It suffices for each focal element of K1(m1) to multiply it with the focal elements of K2(m2)
and then to pool all combinations which are equivalent under the algebra of sets. While very costly in term on memory storage in the worst case (i.e. when all m(A) > 0, A ∈ DΘ or A ∈ 2 Θref ), the DSm rule however requires much smaller memory storage than when working with S
Θ, i.e. working with a minimal refined frame satisfying Shafer's model.

In most fusion applications only a small subset of elements of DΘ have a non null basic belief mass because all the commitments are just usually impossible to obtain precisely when the dimension of the problem increases. Thus, it is not necessary to generate and keep in memory all elements of DΘ (or eventually S
Θ) but only those which have a positive belief mass. However there is a real technical challenge on how to manage efficiently all elements of the hyper-power set. This problem is obviously much more difficult when trying to work on a refined frame of discernment Θref if one really prefers to use Dempster-Shafer theory and apply Dempster's rule of combination. It is important to keep in mind that the ultimate and minimal refined frame consisting in exhaustive and exclusive finite set of refined exclusive hypotheses is just impossible to justify and to define precisely for all problems dealing with fuzzy and ill-defined continuous concepts. A discussion on refinement with an example has be included in [31].

## 2.5 The Hybrid Dsm Rule Of Combination

When the free DSm model Mf(Θ) does not hold due to the true nature of the fusion problem under consideration which requires to take into account some known integrity constraints, one has to work with a proper hybrid DSm model M(Θ) 6= Mf(Θ). In such case, the hybrid DSm rule (DSmH) of combination based on the chosen hybrid DSm model M(Θ) for k ≥ 2 independent sources of information is defined for all A ∈ DΘ
as [31]:

$$m_{D S m H}(A)=m_{\mathcal{M}(\Theta)}(A)\triangleq\phi(A)\Big[S_{1}(A)+S_{2}(A)+S_{3}(A)\Big]$$
13
where all sets involved in formulas are in the canonical form and φ(A) is the characteristic non-emptiness function of a set A, i.e. φ(A) = 1 if A /∈ ∅ and φ(A) = 0 otherwise, where ∅ , {∅M, ∅}. ∅M is the set of all elements of DΘ which have been forced to be empty through the constraints of the model M and ∅ is the classical/universal empty set. S1(A) ≡ mMf (θ)(A), S2(A), S3(A) are defined by

$$S_{1}(A)\triangleq\sum_{\begin{array}{l}{X_{1},X_{2},\ldots,X_{k}\in D^{\Delta}}\\ {X_{1}\cap X_{2}\cap\ldots\cap X_{k}=A}\end{array}}\prod_{i=1}^{k}m_{i}(X_{i})$$
$$(5)$$
$$(6)$$
$$S_{2}(A)\stackrel{{\triangle}}{{=}}\sum_{\begin{subarray}{c}X_{1},X_{2},\ldots,X_{k}\in\mathfrak{G}\\ \mathbb{U}=A\mathbb{V}[(l\ell\mathfrak{G}\mathfrak{G})\wedge(A=I_{\ell})]\end{subarray}}\prod_{i=1}^{k}m_{i}(X_{i})\tag{7}$$  $$S_{3}(A)\stackrel{{\triangle}}{{=}}\sum_{\begin{subarray}{c}X_{1},X_{2},\ldots,X_{k}\in\mathfrak{D}^{\Theta}\\ X_{1}\cup X_{2}\cup\ldots\cap X_{k}\in\mathfrak{G}\end{subarray}}\prod_{i=1}^{k}m_{i}(X_{i})\tag{8}$$

with U , u(X1)∪u(X2)∪**. . .**∪u(Xk) where u(X) is the union of all θithat compose X, It , θ1∪θ2∪**. . .**∪θn is the total ignorance. S1(A) corresponds to the classic DSm rule for k independent sources based on the free DSm model Mf(Θ); S2(A) represents the mass of all relatively and absolutely empty sets which is transferred