From now on, we prefer to use matrices to describe the masses, i.e.

$$\begin{bmatrix}1-\epsilon_{1}&0&\epsilon_{1}\\ 0&1-\epsilon_{2}&\epsilon_{2}\end{bmatrix}$$

- Using Dempster's rule of combination, one gets

$$m(\theta_{3})={\frac{(\epsilon_{1}\epsilon_{2})}{(1-\epsilon_{1})\cdot0+0\cdot(1-\epsilon_{2})+\epsilon_{1}\epsilon_{2}}}=1$$

which is absurd (or at least counter-intuitive). Note that whatever positive values for ǫ1, ǫ2 are, Dempster's rule of combination provides always the same result (one) which is abnormal. The only acceptable and correct result obtained by Dempster's rule is really obtained only in the trivial case when ǫ1 = ǫ2 = 1, i.e. when both sources agree in θ3 with certainty which is obvious.

- Using the DSm rule of combination based on free-DSm model, one gets m(θ3) = ǫ1ǫ2, m(θ1 ∩ θ2) =
(1−ǫ1)(1−ǫ2), m(θ1∩θ3) = (1−ǫ1)ǫ2, m(θ2∩θ3) = (1−ǫ2)ǫ1 and the others are zero which appears more reliable/trustable.

- Going back to Shafer's model and using the hybrid DSm rule of combination, one gets m(θ3) = ǫ1ǫ2, m(θ1 ∪ θ2) = (1 − ǫ1)(1 − ǫ2), m(θ1 ∪ θ3) = (1 − ǫ1)ǫ2, m(θ2 ∪ θ3) = (1 − ǫ2)ǫ1 and the others are zero.
Note that in the special case when ǫ1 = ǫ2 = 1/2, one has

$$\begin{array}{l l l}{{m_{1}(\theta_{1})=1/2}}&{{m_{1}(\theta_{2})=0}}&{{m_{1}(\theta_{3})=1/2}}\end{array}$$
$$m_{2}(\theta_{1})=0\quad m_{2}(\theta_{2})=1/2\quad m_{2}(\theta_{3})=1/2$$

Dempster's rule of combinations still yields m(θ3) = 1 while the hybrid DSm rule based on the same Shafer's model yields now m(θ3) = 1/4, m(θ1 ∪ θ2) = 1/4, m(θ1 ∪ θ3) = 1/4, m(θ2 ∪ θ3) = 1/4 which is normal.

2.6.3 Comparison with Smets, Yager and Dubois & Prade rules We compare the results provided by DSmT rules and the main common rules of combination on the following very simple numerical example where only 2 independent sources (a priori assumed equally reliable) are involved and providing their belief initially on the 3D frame Θ = {θ1, θ2, θ3}. It is assumed in this example that Shafer's model holds and thus the belief assignments m1(.) and m2(.) do not commit belief to internal conflicting information. m1(.) and m2(.) are chosen as follows:

$$\begin{array}{l l l l}{{m_{1}(\theta_{1})=0.1}}&{{\quad m_{1}(\theta_{2})=0.4\quad}}&{{\quad m_{1}(\theta_{3})=0.2\quad}}&{{\quad m_{1}(\theta_{1}\cup\theta_{2})=0.3}}\\ {{}}&{{}}&{{}}&{{}}\\ {{m_{2}(\theta_{1})=0.5}}&{{\quad m_{2}(\theta_{2})=0.1}}&{{\quad m_{2}(\theta_{3})=0.3\quad}}&{{\quad m_{2}(\theta_{1}\cup\theta_{2})=0.1}}\end{array}$$

These belief masses are usually represented in the form of a belief mass matrix M given by

$$\mathbf{M}={\begin{bmatrix}0.1&0.4&0.2&0.3\\ 0.5&0.1&0.3&0.1\end{bmatrix}}$$

(9)
where index i for the rows corresponds to the index of the source no. i and the indexes j for columns of M
correspond to a given choice for enumerating the focal elements of all sources. In this particular example, index j = 1 corresponds to θ1, j = 2 corresponds to θ2, j = 3 corresponds to θ3 and j = 4 corresponds to θ1∪θ2.

Now let's imagine that one finds out that θ3 is actually truly empty because some extra and certain knowledge on θ3 is received by the fusion center. As example, θ1, θ2 and θ3 may correspond to three suspects
(potential murders) in a police investigation, m1(.) and m2(.) corresponds to two reports of independent witnesses, but it turns out that finally θ3 has provided a strong alibi to the criminal police investigator once arrested

$$(9)$$

15