
## 2.7.2 Example

Here is a simple example of fusion with multiple-interval masses. For simplicity, this example is a particular case when the theorem of admissibility (see [31] p. 138 for details) is verified by a few points, which happen to be just on the bounders. It is an extreme example, because we tried to comprise all kinds of possibilities which may occur in the imprecise or very imprecise fusion. So, let's consider a fusion problem over Θ = {θ1, θ2},
two independent sources of information with the following imprecise admissible belief assignments

| A ∈ DΘ   | mI 1 (A)                | mI 2 (A)              |
|----------|-------------------------|-----------------------|
| θ1       | [0.1, 0.2] ∪ {0.3}      | [0.4, 0.5]            |
| θ2       | (0.4, 0.6) ∪ [0.7, 0.8] | [0, 0.4] ∪ {0.5, 0.6} |

![0_image_0.png](0_image_0.png)

Table 3: Inputs of the fusion with imprecise bba's.

Using the DSm classic (DSmC) rule for sets, one gets mI(θ1) = ([0.1, 0.2] ∪ {0.3})  [0.4, 0.5]
= ([0.1, 0.2]  [0.4, 0.5]) ∪ ({0.3}  [0.4, 0.5])
= [0.04, 0.10] ∪ [0.12, 0.15]
mI(θ2) = ((0.4, 0.6) ∪ [0.7, 0.8])  ([0, 0.4] ∪ {0.5, 0.6})
= ((0.4, 0.6)  [0, 0.4]) ∪ ((0.4, 0.6)  {0.5, 0.6})
∪ ([0.7, 0.8]  [0, 0.4]) ∪ ([0.7, 0.8]  {0.5, 0.6})
= (0, 0.24) ∪ (0.20, 0.30) ∪ (0.24, 0.36) ∪ [0, 0.32]
∪ [0.35, 0.40] ∪ [0.42, 0.48] = [0, 0.40] ∪ [0.42, 0.48]
mI(θ1 ∩ θ2) = [([0.1, 0.2] ∪ {0.3})  ([0, 0.4] ∪ {0.5, 0.6})] ⊞ [[0.4, 0.5]
 ((0.4, 0.6) ∪ [0.7, 0.8])]
= [([0.1, 0.2]  [0, 0.4]) ∪ ([0.1, 0.2]  {0.5, 0.6})
∪ ({0.3}  [0, 0.4]) ∪ ({0.3}  {0.5, 0.6})]
⊞ [([0.4, 0.5]  (0.4, 0.6)) ∪ ([0.4, 0.5]  [0.7, 0.8])]
= [[0, 0.08] ∪ [0.05, 0.10] ∪ [0.06, 0.12] ∪ [0, 0.12]
∪ {0.15, 0.18}] ⊞ [(0.16, 0.30) ∪ [0.28, 0.40]]
= [[0, 0.12] ∪ {0.15, 0.18}] ⊞ (0.16, 0.40]
= (0.16, 0.52] ∪ (0.31, 0.55] ∪ (0.34, 0.58] = (0.16, 0.58]
Hence finally the fusion admissible result with DSmC rule is given by:

| A ∈ DΘ   | mI (A) = [mI 1 ⊕ mI 2 ](A)   |
|----------|------------------------------|
| θ1       | [0.04, 0.10] ∪ [0.12, 0.15]  |
| θ2       | [0, 0.40] ∪ [0.42, 0.48]     |
| θ1 ∩ θ2  | (0.16, 0.58]                 |
| θ1 ∪ θ2  | 0                            |

Table 4: Fusion result with the DSmC rule.

If one finds out6that θ1 ∩θ2 M≡ ∅ (this is our hybrid model M one wants to deal with), then one uses the hybrid DSm rule for sets (11): mIM(θ1 ∩ θ2) = 0 and mIM(θ1 ∪ θ2) = (0.16, 0.58], the others imprecise masses are not changed.