
## 3.1 Pcr Formulas

The PCR5 formula for the combination of two sources (s = 2) is given by: m**P CR**5(∅) = 0 and ∀X ∈ GΘ **\{∅}**

$$m_{PCR\mathbb{B}}(X)=m_{12}(X)+\sum_{\begin{subarray}{c}Y\in G^{m}(X)\\ X\cap Y=\emptyset\end{subarray}}[\frac{m_{1}(X)^{2}m_{2}(Y)}{m_{1}(X)+m_{2}(Y)}+\frac{m_{2}(X)^{2}m_{1}(Y)}{m_{2}(X)+m_{1}(Y)}]\tag{15}$$
21
where all sets involved in formulas are in canonical form and where GΘ corresponds to classical power set 2 Θ if Shafer's model is used, or to a constrained hyper-power set DΘ if any other hybrid DSm model is used instead, or to the super-power set S
Θ if the minimal refinement Θref of Θ is used; m12(X) ≡ m∩(X) corresponds to the conjunctive consensus on X between the s = 2 sources and where all denominators are different from zero.

If a denominator is zero, that fraction is discarded.

A general formula of PCR5 for the fusion of s > 2 sources has been proposed in [34], but a more intuitive PCR formula (denoted PCR6) which provides good results in practice has been proposed by Martin and Osswald in [34] (pages 69-88) and is given by: m**P CR**6(∅) = 0 and ∀X ∈ GΘ **\ {∅}**

$$m_{PCRB}(X)=m_{12\ldots s}(X)+\sum_{i=1}^{s}m_{i}(X)^{2}\sum_{\begin{subarray}{c}i=1\\ k=1\\ (Y_{\sigma_{i}(1)})=1\end{subarray}}^{s}\sum_{\begin{subarray}{c}i=1\\ (Y_{\sigma_{i}(k)})^{\prime}\cap X\equiv\emptyset\\ (Y_{\sigma_{i}(1)})=1\end{subarray}}\left(\frac{\left(\frac{\prod_{j=1}^{s+1}m_{\sigma_{i}(j)}(Y_{\sigma_{i}(j)})}{\prod_{j=1}^{s+1}m_{\sigma_{i}(j)}(Y_{\sigma_{i}(j)})}\right)}{\left(m_{i}(X)+\sum_{j=1}^{s+1}m_{\sigma_{i}(j)}(Y_{\sigma_{i}(j)})\right)}\right)\tag{16}$$
$$(17)$$

where σi counts from 1 to s avoiding i:

$$\left\{\begin{array}{ll}\sigma_{i}(j)=j&\mbox{if$j<i$,}\\ \sigma_{i}(j)=j+1&\mbox{if$j\geq i$,}\end{array}\right.$$
Since Yiis a focal element of expert/source i, mi(X)+ Xs−1
source $i$, $m_{i}(X)+\sum_{j=1}^{s-1}m_{\sigma_{i}(j)}(Y_{\sigma_{i}(j)})\neq0$; the belief mass assignment $\sigma_{i}$, $m_{i}(X)+\sum_{j=1}^{s-1}m_{\sigma_{i}(j)}(Y_{\sigma_{i}(j)})\neq0$; the belief mass assignment $\sigma_{i}$, $m_{i}(X)+\sum_{j=1}^{s-1}m_{\sigma_{i}(j)}(Y_{\sigma_{i}(j)})\neq0$; the belief mass assignment $\sigma_{i}$, \(m_{i}(X)+\sum_{j=1}^{s-1}m_{\sigma_{i}(j)}(Y_{\sigma_{i}(j)})\neq 0\); the belief mass assignment \(\sigma_{i}  
m12**...s**(X) ≡ m∩(X) corresponds to the conjunctive consensus on X between the s > 2 sources. For two sources (s = 2), PCR5 and PCR6 formulas coincide.

## 3.2 Examples

- **Example 1**: Let's take Θ = {**A, B**} of exclusive elements (Shafer's model), and the following bba:

| A     | B    | A ∪ B   |      |
|-------|------|---------|------|
| m1(.) | 0.6  | 0       | 0.4  |
| m2(.) | 0    | 0.3     | 0.7  |
| m∩(.) | 0.42 | 0.12    | 0.28 |

The conflicting mass is k12 = m∩(A∩B) and equals m1(A)m2(B) + m1(B)m2(A) = 0.18. Therefore A and B are the only focal elements involved in the conflict. Hence according to the PCR5 hypothesis only A and B deserve a part of the conflicting mass and A ∪ B do not deserve. With PCR5, one redistributes the conflicting mass k12 = 0.18 to A and B proportionally with the masses m1(A) and m2(B) assigned to A and B respectively.