
## 3.3 Zadeh'S Example

We compare here the solutions for well-known Zadeh's example [53, 56] provided by several fusion rules.

A detailed presentation with more comparisons can be found in [31, 34]. Let's consider Θ = {**M, C, T**} as the frame of three potential origins about possible diseases of a patient (M standing for *meningitis*, C for concussion and T for *tumor*), the Shafer's model and the two following belief assignments provided by two independent doctors after examination of the same patient.

$$\begin{array}{l}{{m_{1}(M)=0.9}}\\ {{m_{2}(M)=0}}\end{array}$$
m1(M) = 0.9 m1(C) = 0 m1(T) = 0.1
m2(M) = 0 m2(C) = 0.9 m2(T) = 0.1
The total conflicting mass is high since it is

$$\begin{array}{l}{{m_{1}(C)=0}}\\ {{m_{2}(C)=0.9}}\end{array}$$
$$\begin{array}{c}{{m_{1}(T)=0.1}}\\ {{m_{2}(T)=0.1}}\end{array}$$

m1(M)m2(C) + m1(M)m2(T) + m2(C)m1(T) = 0.99
- with Dempster's rule and Shafer's model (DS), one gets the counter-intuitive result (see justifications in [11, 31, 46, 50, 53]): mDS(T) = 1
- with Yager's rule [50] and Shafer's model: mY (M ∪ C ∪ T) = 0.99 and mY (T) = 0.01

- with DSmH and Shafer's model:
m**DSmH**(M ∪ C) = 0.81 m**DSmH**(T) = 0.01

$$m_{D S m H}(T)=0.01$$

m**DSmH**(M ∪ T) = m**DSmH**(C ∪ T) = 0.09

- The Dubois & Prade's rule (DP) [11] based on Shafer's model provides in Zadeh's example the same result as DSmH, because DP and DSmH coincide in all static fusion problems7.

- with PCR5 and Shafer's model: m**P CR**5(M) = m**P CR**5(C) = 0.486 and m**P CR**5(T) = 0.028.
One sees that when the total conflict between sources becomes high, DSmT is able (upon authors opinion) to manage more adequately through DSmH or PCR5 rules the combination of information than Dempster's rule, even when working with Shafer's model - which is only a specific hybrid model. DSmH rule is in agreement with DP rule for the static fusion, but DSmH and DP rules differ in general (for non degenerate cases) for dynamic fusion while PCR5 rule is the most exact proportional conflict redistribution rule. Besides this particular example, we showed in [31] that there exist several infinite classes of counter-examples to Dempster's rule which can be solved by DSmT.

In summary, DST based on Dempster's rule provides counter-intuitive results in Zadeh's example, or in non-
Bayesian examples similar to Zadeh's and no result when the conflict is 1. Only ad-hoc discounting techniques allow to circumvent troubles of Dempster's rule or we need to switch to another model of representation/frame; in the later case the solution obtained doesn't fit with the Shafer's model one originally wanted to work with. We want also to emphasize that in dynamic fusion when the conflict becomes high, both DST [24] and Smets' Transferable Belief Model (TBM) [39] approaches fail to respond to new information provided by new sources.

This can be easily showed by the very simple following example.

Example (where TBM doesn't respond to new information):
Let Θ = {**A, B, C**} with the (precise) bba's m1(A) = 0.4, m1(C) = 0.6 and m2(A) = 0.7, m2(B) = 0.3.

Then one gets8 with Dempster's rule, Smets' TBM (i.e. the non-normalized version of Dempster's combina7Indeed DP rule has been developed for static fusion only while DSmH has been developed to take into account the