
## 4.2 Notion Of Dsm Cardinality

One important notion involved in the definition of the Generalized Pignistic Transformation (GPT) is the DSm cardinality. The *DSm cardinality* of any element A of hyper-power set DΘ, denoted CM(A), corresponds to the number of parts of A in the corresponding fuzzy/vague Venn diagram of the problem (model M) taking into account the set of integrity constraints (if any), i.e. all the possible intersections due to the nature of the elements θi. This *intrinsic cardinality* depends on the model M (free, hybrid or Shafer's model). M is the model that contains A, which depends both on the dimension n = |Θ| and on the number of non-empty intersections present in its associated Venn diagram (see [31] for details ). The DSm cardinality depends on the cardinal of Θ = {θ1, θ2**, . . . , θ**n} and on the model of DΘ (i.e., the number of intersections and between what elements of Θ - in a word the structure) at the same time; it is not necessarily that every singleton, say θi, has the same DSm cardinal, because each singleton has a different structure; if its structure is the simplest (no intersection of this elements with other elements) then CM(θi) = 1, if the structure is more complicated (many intersections) then CM(θi) > 1; let's consider a singleton θi: if it has 1 intersection only then CM(θi) = 2, for 2 intersections only CM(θi) is 3 or 4 depending on the model M, for m intersections it is between m + 1 and 2 m depending on the model; the maximum DSm cardinality is 2 n−1and occurs for θ1 ∪θ2∪**. . .**∪θn in the free model Mf; similarly for any set from DΘ: the more complicated structure it has, the bigger is the DSm cardinal; thus the DSm cardinality measures the complexity of en element from DΘ, which is a nice characterization in our opinion; we may say that for the singleton θi not even |Θ| counts, but only its structure (= how many other singletons intersect θi). Simple illustrative examples are given in Chapter 3 and 7 of [31]. One has 1 ≤ CM(A) ≤ 2 n − 1.

CM(A) must not be confused with the classical cardinality |A| of a given set A (i.e. the number of its distinct elements) - that's why a new notation is necessary here. CM(A) is very easy to compute by programming from the algorithm of generation of DΘ given explicated in [31].

Example: let's take back the example of the simple hybrid DSm model described in section 2.2, then one gets

the following list of elements (with their DSm cardinal) for the restricted DΘ taking into account the integrity

constraints of this hybrid model:

A ∈ DΘ CM(A)

α0 , ∅ 0 α1 , θ1 ∩ θ2 1

α2 , θ3 1

α3 , θ1 2

α4 , θ2 2

α5 , θ1 ∪ θ2 3 α6 , θ1 ∪ θ3 3

α7 , θ2 ∪ θ3 3

α8 , θ1 ∪ θ2 ∪ θ3 4

Example of DSm cardinals: CM(A) for hybrid model M.

## 4.3 The Generalized Pignistic Transformation

To take a rational decision within DSmT framework, it is necessary to generalize the Classical Pignistic Transformation in order to construct a pignistic probability function from any generalized basic belief assignment m(.) drawn from the DSm rules of combination. Here is the simplest and direct extension of the CPT to define the Generalized Pignistic Transformation:

$$BetP\{A\}=\sum_{X\in D^{\Theta}}\frac{{\cal C}_{\cal M}(X\cap A)}{{\cal C}_{\cal M}(X)}m(X)\tag{19}$$
$$\forall A\in D^{\Theta},$$
Θ**, BetP**{A} =X
26
where CM(X) denotes the DSm cardinal of proposition X for the DSm model M of the problem under consideration.