
## - The Pic Metric

The Probabilistic Information Content (PIC) of a probability measure P{.} associated with a probabilistic source over a discrete finite set Θ = {θ1**, . . . , θ**n} is defined by [42]:

$$PIC(P)=1+\frac{1}{H_{\max}}\cdot\sum_{i=1}^{n}P\{\theta_{i}\}\log_{2}(P\{\theta_{i}\})\tag{21}$$

The PIC is nothing but the dual of the normalized Shannon entropy and thus is actually unit less. **P IC**(P)
takes its values in [0, 1]. **P IC**(P) is maximum, i.e. P ICmax = 1 with any *deterministic* probability and it is minimum, i.e. P ICmin = 0, with the uniform probability over the frame Θ. The simple relationships between H(P) and **P IC**(P) are **P IC**(P) = 1 − (H(P)/Hmax) and H(P) = Hmax · (1 − **P IC**(P)).

## 5.2 The Dsmp Formula

Let's consider a discrete frame Θ with a given model (free DSm model, hybrid DSm model or Shafer's model),
the **DSmP** mapping is defined by **DSmP**ǫ(∅) = 0 and ∀X ∈ GΘ **\ {∅}** by

$$DSmP_{\epsilon}(X)=\sum_{Y\in G^{\Theta}}\frac{\sum_{\begin{subarray}{c}Z\subseteq X\cap Y\\ \mathcal{C}(Z)=1\end{subarray}}m(Z)+\epsilon\cdot\mathcal{C}(X\cap Y)}{\sum_{\begin{subarray}{c}Z\subseteq Y\\ \mathcal{C}(Z)=1\end{subarray}}m(Z)+\epsilon\cdot\mathcal{C}(Y)}m(Y)\tag{22}$$

where ǫ ≥ 0 is a tuning parameter and GΘ corresponds to the generic set (2 Θ, S
Θ or DΘ including eventually all the integrity constraints (if any) of the model M); C(X ∩ Y ) and C(Y ) denote the DSm cardinals11 of the sets X ∩ Y and Y respectively. ǫ allows to reach the maximum PIC value of the approximation of m(.) into a subjective probability measure. The smaller ǫ, the better/bigger PIC value. In some particular degenerate cases however, the **DSmP**ǫ=0 values cannot be derived, but the **DSmP**ǫ>0 values can however always be derived by choosing ǫ as a very small positive number, say ǫ = 1/1000 for example in order to be as close as we want to the maximum of the PIC. When ǫ = 1 and when the masses of all elements Z having C(Z) = 1 are zero, (22)
reduces to (19), i.e. DSmPǫ=1 = **BetP**. The passage from a free DSm model to a Shafer's model involves the passage from a structure to another one, and the cardinals change as well in the formula (22).

DSmP works for all models (free, hybrid and Shafer's). In order to apply classical transformation (Pignistic, Cuzzolin's one, Sudano's ones, etc - see [36]), we need at first to refine the frame (on the cases when it is possible!) in order to work with Shafer's model, and then apply their formulas. In the case where refinement makes sense, then one can apply the other subjective probabilities on the refined frame. **DSmP** works on the refined frame as well and gives the same result as it does on the non-refined frame. Thus **DSmP** with ǫ > 0 works on any models and so is very general and appealing. **DSmP** does a redistribution of the ignorance mass with respect to both the singleton masses and the singletons' cardinals in the same time. Now, if all masses of singletons involved in all ignorances are different from zero, then we can take ǫ = 0, and **DSmP** gives the best result, i.e. the best PIC value. In summary, **DSmP** does an 'improvement' over previous known probabilistic transformations in the sense that **DSmP** mathematically makes a more accurate redistribution of the ignorance masses to the singletons involved in ignorances. **DSmP** and **BetP** work in both theories: DST (= Shafer's model) and DSmT (= free or hybrid models) as well.

28