D1, D2 and D3 have no element in common two by two and their union is DΘ **\ {∅}**.

Simple example of HPSD: Let's consider Θ = {θ1, θ2, θ3} with Shafer's model (i.e. all elements of Θ are exclusive) and let's assume that the truth is in θ2 ∪ θ3, i.e. the conditioning term is θ2 ∪ θ3. Then one has the following HPSD: D1 = {θ2, θ3, θ2 ∪θ3}, D2 = {θ1} and D3 = {θ1 ∪θ2, θ1 ∪θ3, θ1 ∪θ2 ∪θ3}. More complex and detailed examples can be found in [34].

## 7.3 Quantitative Belief Conditioning Rules (Bcr)

Since there exists actually many ways for redistributing the masses of elements outside of A (the conditioning event) to those inside A, several BCR's have been proposed in [34]. In this introduction, we will not browse all the possibilities for doing these redistributions and all BCR's formulas but only one, the BCR number 17 (i.e.

BCR17) which does in our opinion the most refined redistribution since:
- the mass m(W) of each element W in D2 ∪ D3 is transferred to those X ∈ D1 elements which are included in W if any proportionally with respect to their non-empty masses;
- if no such X exists, the mass m(W) is transferred in a pessimistic/prudent way to the k-largest element from D1 which are included in W (in equal parts) if any;
- if neither this way is possible, then m(W) is indiscriminately distributed to all X ∈ D1 proportionally with respect to their nonzero masses.

BCR17 is defined by the following formula (see [34], Chap. 9 for detailed explanations and examples):

$$m_{BCR17}(X|A)=m(X)\cdot\left[S_{D_{1}}+\sum_{\begin{subarray}{c}W\in D_{2}\cup D_{3}\\ X\subset W\end{subarray}}\frac{m(W)}{S(W)}\right]+\sum_{\begin{subarray}{c}W\in D_{2}\cup D_{3}\\ X\subset W,X\text{is}k\text{-largest}\\ S(W)\neq0\end{subarray}}m(W)/k\tag{35}$$
37
where "X is k-largest" means that X is the k-largest (with respect to inclusion) set included in W and

$\begin{array}{c}\includegraphics[height=142.26375pt]{Fig1}\end{array}$  $\begin{array}{c}\includegraphics[height=142.26375pt]{Fig2}\end{array}$  $\begin{array}{c}\includegraphics[height=142.26375pt]{Fig3}\end{array}$  $\begin{array}{c}\includegraphics[height=142.26375pt]{Fig4}\end{array}$  $\begin{array}{c}\includegraphics[height=142.26375pt]{Fig5}\end{array}$  $\begin{array}{c}\includegraphics[height=142.26375pt]{Fig6}\end{array}$  $\begin{array}{c}\includegraphics[height=142.26375pt]{Fig7}\end{array}$  \(\begin{array}{c}\includegraphics[height=142.26375pt]{Fig8}\end{array}\
Note: The authors mentioned in an Erratum to the printed version of the second volume of DSmT book series (http://fs.gallup.unm.edu//Erratum.pdf) and they also corrected the online version of the aforementioned book (see page 240 in http://fs.gallup.unm.edu//DSmT-book2.pdf that all denominators of the BCR's formulas are naturally supposed to be different from zero. Of course, Shafer's conditional rule as stated in Theorem 3.6, page 67 of [24] does not work when the denominator is zero and that's why Shafer has introduced the condition Bel(B¯) < 1 (or equivalently Pl(B) > 0) in his theorem when the conditioning term is B.

A simple example for BCR17: Let's consider Θ = {θ1, θ2, θ3} with Shafer's model (i.e. all elements of Θ are exclusive) and let's assume that the truth is in θ2 ∪ θ3, i.e. the conditioning term is A , θ2 ∪ θ3. Then one has the following HPSD:

$$D_{1}=\{\theta_{2},\theta_{3},\theta_{2}\cup\theta_{3}\},\qquad D_{2}=\{\theta_{1}\}$$
$$D_{3}=\{\theta_{1}\cup\theta_{2},\theta_{1}\cup\theta_{3},\theta_{1}\cup\theta_{2}\cup\theta_{3}\}.$$

Let's consider the following prior bba: m(θ1) = 0.2, m(θ2) = 0.1, m(θ3) = 0.2, m(θ1 ∪ θ2) = 0.1, m(θ2 ∪ θ3) = 0.1 and m(θ1 ∪ θ2 ∪ θ3) = 0.3.