Therefore by convention, we write DΘ = (Θ,∪,∩) which means that Θ generates DΘ under operators ∪
and ∩. The dual (obtained by switching ∪ and ∩ in expressions) of DΘ is itself. There are elements in DΘ
which are self-dual (dual to themselves), for example α8 for the case when n = 3 in the following example.

The cardinality of DΘ is majored by 2 2 nwhen the cardinality of Θ equals n, i.e. |Θ| = n. The generation of hyper-power set DΘ is closely related with the famous Dedekind's problem [3, 4] on enumerating the set of isotone Boolean functions. The generation of the hyper-power set is presented in [31]. Since for any given finite set Θ, |DΘ**| ≥ |**2 Θ| we call DΘ the *hyper-power set* of Θ.

## Example Of The First Hyper-Power Sets:

- For the degenerate case (n = 0) where Θ = {}, one has DΘ = {α0 , ∅} and |DΘ| = 1.

- When Θ = {θ1}, one has DΘ = {α0 , ∅, α1 , θ1} and |DΘ| = 2.

- When Θ = {θ1, θ2}, one has DΘ = {α0, α1**, . . . , α**4} and |DΘ| = 5 with α0 , ∅, α1 , θ1 ∩ θ2, α2 , θ1, α3 , θ2 and α4 , θ1 ∪ θ2.

- When Θ = {θ1, θ2, θ3}, one has DΘ = {α0, α1**, . . . , α**18} and |DΘ| = 19 with

| α3 , θ1 ∩ θ3                           | α12 , (θ1 ∩ θ2) ∪ θ3   |
|----------------------------------------|------------------------|
| α4 , θ2 ∩ θ3                           | α13 , (θ1 ∩ θ3) ∪ θ2   |
| α5 , (θ1 ∪ θ2) ∩ θ3                    | α14 , (θ2 ∩ θ3) ∪ θ1   |
| α6 , (θ1 ∪ θ3) ∩ θ2                    | α15 , θ1 ∪ θ2          |
| α7 , (θ2 ∪ θ3) ∩ θ1                    | α16 , θ1 ∪ θ3          |
| α8 , (θ1 ∩ θ2) ∪ (θ1 ∩ θ3) ∪ (θ2 ∩ θ3) | α17 , θ2 ∪ θ3          |
| α9 , θ1                                | α18 , θ1 ∪ θ2 ∪ θ3     |

The cardinality of hyper-power set DΘ for n ≥ 1 follows the sequence of Dedekind's numbers [26], i.e.

1,2,5,19,167, 7580,7828353,... and analytical expression of Dedekind's numbers has been obtained recently by Tombak in [45] (see [31] for details on generation and ordering of DΘ). Interesting investigations on the programming of the generation of hyper-power sets for engineering applications have been done in Chapter 15 of [34] and in [36].

## Examples Of Hyper-Power Sets:

Let's consider the frames Θ1 = {**A, B**} and Θ2 = {**X, Y** }, then their corresponding hyper-power sets are DΘ1={A,B} = {∅, A ∩ **B, A, B, A** ∪ B} and DΘ2={X,Y } = {∅, X ∩ **Y, X, Y, X** ∪ Y }. Let's consider a refined frame Θref = {θ1, θ2, θ3, θ4} where the granules θi, i = 1**, . . . ,** 4 are now considered as truly exhaustive and exclusive. If A and B are expressed more precisely in function of the granules θi by example as A , {θ1, θ2, θ3} and B , {θ2, θ4} then

$D^{\Theta_{1}=\{A,B\}}=\{\emptyset,A\cap B,A,B,A\cup B\}$  $$=\{\emptyset,\underbrace{\{\theta_{1},\theta_{2},\theta_{3}\}}_{A\cap B=\{\theta_{2}\}}\cap\underbrace{\{\theta_{2},\theta_{4}\}}_{A},\underbrace{\{\theta_{1},\theta_{2},\theta_{3}\}}_{B},\underbrace{\{\theta_{2},\theta_{4}\}}_{B}$$ $$\underbrace{\{\{\theta_{1},\theta_{2},\theta_{3}\}}_{A\cup B=\{\theta_{1},\theta_{2},\theta_{3}\}}_{A}$$
5

![0_image_0.png](0_image_0.png)

= {∅, θ2, θ1 ∪ θ2 ∪ θ3, θ2 ∪ θ4, θ1 ∪ θ2 ∪ θ3 ∪ θ4}
6= 2Θ1={A,B}