Theorem 1 *Pruning all inconsistent values for* VALSYM(Σ, [X1**, ., X**n]) is NP-hard, even when |Σ| is linearly bounded.

Proof: In (Walsh 2007), we reduce 3-SAT to deciding if a particular VALSYM constraint has a solution. ✷
With value symmetry, whilst pruning all symmetric values is NP-hard, method likes those in
(Roney-Dougal *et al.* 2004; Puget 2005) will eliminate all symmetric solutions in polynomial time. Despite the negative result given in Theorem 1, value symmetry appears easier to break than variable symmetry both in theory and in practice. For example, with variable symmetry, we prove in (Bessiere *et al.* 2004) that just eliminating all symmetric solutions is itself NP-hard.

## Interchangeable Values

So far, we have considered symmetries in general and ignored any special properties of the symmetry group. A common type of value symmetry with special properties that we can exploit is that due to interchangeable values. We can break all such value symmetry using value *precedence*
(Law & Lee 2004), an idea which has been used in many contexts including the least number heuristic (Zhang 1996). To ensure value precedence, we can use the global constraint PRECEDENCE([X1**, ., X**n]). This holds iff the first time we use j is before the first time we use k for all **j < k**. For example, consider an assignment like:
X1, X2, X3**, . . . , X**n = 1, 1, 2, 1, 3**, . . .,** 2 (9)
This satisfies value precedence as 1 first occurs before 2, 2 first occurs before 3, etc. Now consider the symmetric assignment in which we swap 2 with 3:
X1, X2, X3**, . . . , X**n = 1, 1, 3, 1, 2**, . . .,** 3 (10)
This does not satisfy value precedence as 3 first occurs before 2. Posting a PRECEDENCE constraint eliminates all symmetric solutions due to interchangeable values. In (Walsh 2006b), we give a linear time propagator for the PRECEDENCE constraint. In (Walsh 2007), we argue that PRECEDENCE is in fact equivalent to VALSYM.

Another way to ensure value precedence is to channel into dual variables, Zj which record the first index using each value j (Puget 2005). This maps value symmetry into variable symmetry on the Zj. We can then break this variable symmetry by posting simple ordering constraints:
Z1 < Z2 < Z3 **< . . . < Z**m (11)
This ensures that the first occurrence of 1 is before that of 2, that of 2 is before 3, etc. For example, the assignment in (9) satisfies (11) as Z1 = 1, Z2 = 3 and Z3 = 5.

However, the symmetric assignment in (10) does not satisfy (11) as Z2 = 5 but Z3 = 3. Puget proves that we can, in fact, break any value symmetry with a linear number of ordering constraints on the Zj. Unfortunately, even with just two value symmetries, Puget's method hinders propagation (Walsh 2007). This is supported by the experiments in
(Walsh 2007) where we see faster and more effective symmetry breaking with the global PRECEDENCE constraint.

This is therefore a promising method to eliminate the symmetry due to interchangeable values.

## Dynamic Methods

An alternative to static methods which add constraints to eliminate symmetric solutions are dynamic methods which modify the search procedure to ignore symmetric branches. For example, with value symmetries, the GEtree method dynamically eliminates all symmetric solutions from a backtracking search procedure in O(n 4log(n)) time
(Roney-Dougal *et al.* 2004). Dynamic methods have the advantage that they do not conflict with the branching heuristic. However, dynamic methods do not prune the search space as much. Suppose we are at a particular node in the search tree explored by the GE-tree method. The GE-tree method essential performs only forward checking, pruning symmetric assignments from the domain of the *next* branching variable. Unlike static methods, the GE-tree method does not prune *deeper* variables. By comparison, static symmetry breaking constraints can prune deeper variables, resulting in interactions between the problem constraints and additional domain prunings. For this reason, static symmetry breaking methods can solve certain problems exponentially quicker than dynamic methods.

Theorem 2 There exists a model of the pigeonhole problem in n *variables and* n + 1 interchangeable values such that, given any variable and value ordering, the GE-tree method explores O(2n) *branches, but which static symmetry breaking methods like value precedence solve in just* O(n 2) *time.*
Proof: See (Walsh 2007). ✷
This theoretical result supports the experimental results in
(Puget 2005) showing that static methods for breaking value symmetry outperform dynamic methods. Nevertheless, dynamic methods have been found useful as they may not conflict with the branching heuristic (Gargani & Refalo 2007; Van Hentenryck & Michel 2008). An interesting direction for future work are hybrid methods that combine the best features of static and dynamic symmetry breaking.

## Related Work

Puget proved that symmetric solutions can be eliminated by the addition of suitable constraints (Puget 1993).

Crawford *et al.* presented the first general method for constructing variable symmetry breaking constraints
(Crawford *et al.* 1996). To deal with large number of symmetries, Aloul *et al.* suggest breaking only those symmetries which are generators (Aloul *et al.* 2002). Puget and Walsh independently proposed propagators for value symmetry breaking constraints (Puget 2006; Walsh 2006a). To deal with the exponential number of such value symmetry breaking constraints, Puget proposed a global propagator which does forward checking in polynomial time (Puget 2006).

To eliminate symmetric solutions due to interchangeable values, Law and Lee defined value precedence for finite domain and set variables and proposed a specialized propagator for a pair of interchangeable values (Law & Lee 2004).

Walsh extended this to a propagator for any number of interchangeable values (Walsh 2006b). Value precedence enforces the so-called "least number heuristic" (Zhang 1996).

Finally, an alternative way to break value symmetry statically is to convert it into a variable symmetry by channelling