into a dual Boolean viewpoint in which Bij = 1 iff Xi =
j, and using lexicographical ordering constraints on the Boolean variables (Flener *et al.* 2002; Law & Lee 2006).

More recently, static symmetry breaking constraints have been proposed to eliminate the symmetry due to both interchangeable variables and values (Flener *et al.* 2006; Law *et al.* 2007).

A number of dynamic methods have been proposed to deal with value symmetry. Van Hentenryck *et al.* gave a labelling schema for eliminating all symmetric solutions due to interchangeable values (Van Hentenryck *et al.* 2003). Inspired by this method, Roney-Dougal *et al.* gave a polynomial method to construct a GE-tree, a search tree without value symmetry (Roney-Dougal *et al.* 2004). Finally, Sellmann and van Hentenryck gave a O(nd3.5 + n 2d 2) dominance detection algorithm for eliminating all symmetric solutions when both variables and values are interchangeable
(Sellmann & Van Hentenryck 2005).

## Conclusions

Value symmetries can be broken either statically (by adding constraints to prune symmetric solutions) or dynamically
(by modifying the search procedure to avoid symmetric branches). We have shown that both approaches have computational limitations. With static methods, we can eliminate all symmetric solutions in polynomial time but pruning all symmetric values is NP-hard in general (or equivalently, we can avoid visiting symmetric leaves of the search tree in polynomial time but avoiding symmetric subtrees is NP-hard). With dynamic methods, we can take exponential time on problems which static methods solve without search. Nevertheless, experimental results in
(Puget 2006; Walsh 2006b; Walsh 2006a; Walsh 2007) and elsewhere show that value symmetry can be dealt with effectively in practice.

These results may be useful to researchers in closely related areas like planning and scheduling where value symmetries arise and need to be eliminated. They may also be useful in areas like model counting, verification, and automated reasoning as value symmetry arises in many of these problems too. There are many open questions raised by this research. For example, are there symmetries where all symmetric values can be pruned tractably? How do we combine the best features of static and dynamic symmetry breaking?

## References

[Aloul *et al.* 2002] Aloul, F.; Ramani, A.; Markov, I.; and Sakallah, K. 2002. Solving difficult SAT instances in the presence of symmetries. In *Proc. of the Design Automation* Conf., 731–736.

[Bessiere *et al.* 2004] Bessiere, C.; Hebrard, E.; Hnich, B.;
and Walsh, T. 2004. The complexity of global constraints. In *Proc. of the 19th National Conf. on AI*. AAAI.

[Crawford *et al.* 1996] Crawford, J.; Luks, G.; Ginsberg, M.; and Roy, A. 1996. Symmetry breaking predicates for search problems. In *Proc. of the 5th Int. Conf. on Knowledge Representation and Reasoning, (KR '96)*, 148–159.

[Flener *et al.* 2002] Flener, P.; Frisch, A.; Hnich, B.; Kiziltan, Z.; Miguel, I.; Pearson, J.; and Walsh, T. 2002. Breaking row and column symmetry in matrix models. In *8th Int.*
Conf. on Principles and Practices of Constraint Programming (CP-2002).

[Flener *et al.* 2006] Flener, P.; Pearson, J.; Sellmann, M.;
and Van Hentenryck, P. 2006. Static and dynamic structural symmetry breaking. In *Proc. of 12th Int. Conf. on Principles and Practice of Constraint Programming (CP2006)*.

[Gargani & Refalo 2007] Gargani, A., and Refalo, P. 2007.

An efficient model and strategy for the steel mill slab design problem. In *Proc. of 13th Int. Conf. on Principles and* Practice of Constraint Programming (CP2007).

[Gent, Petrie, & Puget 2006] Gent, I.; Petrie, K.; and Puget, J.-F. 2006. Symmetry in constraint programming. In *Handbook for Constraint Programming*. Elsevier.

[Law & Lee 2004] Law, Y., and Lee, J. 2004. Global constraints for integer and set value precedence. In *Proc. of* 10th Int. Conf. on Principles and Practice of Constraint Programming (CP2004), 362–376.

[Law & Lee 2006] Law, Y., and Lee, J. 2006. Symmetry Breaking Constraints for Value Symmetries in Constraint Satisfaction. *Constraints* 11(2–3):221–267.

[Law *et al.* 2007] Law, Y.-C.; Lee, J.; Walsh, T.; and Yip, J. 2007. Breaking symmetry of interchangeable variables and values. In 13th Int. Conf. on Principles and Practices of Constraint Programming (CP-2007).

[Puget 1993] Puget, J.-F. 1993. On the satisfiability of symmetrical constrained satisfaction problems. In *Proc. of ISMIS'93*, LNAI 689, 350–361.

[Puget 2005] Puget, J.-F. 2005. Breaking all value symmetries in surjection problems. In *Proc. of 11th Int. Conf.*
on Principles and Practice of Constraint Programming (CP2005).

[Puget 2006] Puget, J.-F. 2006. An efficient way of breaking value symmetries. In Proc. of the 21st National Conf.

on AI. AAAI.

[Roney-Dougal *et al.* 2004] Roney-Dougal, C.; Gent, I.;
Kelsey, T.; and Linton, S. 2004. Tractable symmetry breaking using restricted search trees. In *Proc. of ECAI-2004*.

IOS Press.

[Sellmann & Van Hentenryck 2005] Sellmann, M., and Van Hentenryck, P. 2005. Structural symmetry breaking. In *Proc. of 19th IJCAI*.

[Van Hentenryck & Michel 2008] Van Hentenryck, P., and Michel, L. 2008. The steel mill slab design problem revisited. In Proc. of 5th Int. Workshop on Integration of AI and OR Techniques in Constraint Programming (CP-AI-OR).

[Van Hentenryck *et al.* 2003] Van Hentenryck, P.; Agren, M.; Flener, P.; and Pearson, J. 2003. Tractable symmetry breaking for CSPs with interchangeable values. In Proc. of the 18th IJCAI.

[Walsh 2006a] Walsh, T. 2006a. General symmetry breaking constraints. In *12th Int. Conf. on Principles and Practices of Constraint Programming (CP-2006)*.

[Walsh 2006b] Walsh, T. 2006b. Symmetry breaking using value precedence. In *Proc. of the 17th ECAI*. European Conf. on Artificial Intelligence.