# Reformulating Global Grammar Constraints⋆

George Katsirelos1, Nina Narodytska2, and Toby Walsh2 1 NICTA, Sydney, Australia, email: george.katsirelos@nicta.com.au 2 NICTA and University of NSW, Sydney, Australia, email: ninan@cse.unsw.edu.au, toby.walsh@nicta.com.au Abstract. An attractive mechanism to specify global constraints in rostering and other domains is via formal languages. For instance, the REGULAR and GRAMMAR constraints specify constraints in terms of the languages accepted by an automaton and a context-free grammar respectively. Taking advantage of the fixed length of the constraint, we give an algorithm to transform a context-free grammar into an automaton. We then study the use of minimization techniques to reduce the size of such automata and speed up propagation. We show that minimizing such automata after they have been unfolded and domains initially reduced can give automata that are more compact than minimizing before unfolding and reducing. Experimental results show that such transformations can improve the size of rostering problems that we can "model and run".

## 1 Introduction

Constraint programming provides a wide range of tools for modelling and efficiently solving real world problems. However, modelling remains a challenge even for experts.

Some recent attempts to simplify the modelling process have focused on specifying constraints using formal language theory. For example the REGULAR [1] and GRAMMAR
constraints [2, 3] permit constraints to be expressed in terms of automata and grammars. In this paper, we make two contributions. First, we investigate the relationship between REGULAR and GRAMMAR. In particular, we show that it is often beneficial to reformulate a GRAMMAR constraint as a REGULAR constraint. Second, we explore the effect of minimizing the automaton specifying a REGULAR constraint. We prove that by minimizing this automaton *after* unfolding and initial constraint propagation, we can get an exponentially smaller and thus more efficient representation. We show that these transformations can improve runtimes by over an order of magnitude.

## 2 Background

A constraint satisfaction problem consists of a set of variables, each with a domain of values, and a set of constraints specifying allowed combinations of values for given subsets of variables. A solution is an assignment to the variables satisfying the constraints. A constraint is *domain consistent* iff for each variable, every value in its domain can be extended to an assignment that satisfies the constraint. We will consider
⋆ NICTA is funded by the Australian Government's Department of Broadband, Communications, and the Digital Economy and the Australian Research Council.

arXiv:0903.0475v1 [cs.AI] 3 Mar 2009