
instances and Gecode 2.2.0 for constraint problems, on an Intel Xeon 4 CPU, 2.0 Ghz, 4G RAM. We use a timeout of **3600** sec in all experiments. The problem is to schedule employees to activities subject to various rules, e.g. a full-time employee has one hour for lunch. This rules are specified by a context-free grammar augmented with restrictions on productions [4]. A schedule for an employee has n **= 96** slots of 15 minutes represented by n variables. In each slot, an employee can work on an activity (ai), take a break (b), lunch (l) or rest (r). These rules are specified by the following grammar:
S → RP R, fP (i, j) ≡ 13 ≤ j ≤ 24, P → W bW, L → lL|l, fL(i, j) ≡ j = 4 S → RF R, fF (i, j) ≡ 30 ≤ j ≤ 38, R → rR|r, W → Ai, fW (**i, j**) ≡ j ≥ 4 Ai → aiAi|ai, fA(i, j) ≡ open(i), F → **P LP**
where functions f(**i, j**) are predicates that restrict the start and length of any string matched by a specific production, and **open**(i) is a function that returns 1 if the business is open at i th slot and 0 otherwise. In addition, the business requires a certain number of employees working in each activity at given times during the day. We minimize the number of slots in which employees work such that the demand is satisfied.

As shown in [4], this problem can be converted into a pseudo-Boolean (PB) model.

The GRAMMAR constraint is converted into a SAT formula in conjunctive normal form using the AND/OR graph. To model labour demand for a slot we introduce Boolean variables b(**i, j, a**k), equal to 1 if j th employee performs activity ak at i th time slot. For each time slot i and activity ak we post a pseudo-Boolean constraint Pm j=1 b(**i, j, a**k) >
d(**i, a**k), where m is the number of employees. The objective is modelled using the function Pn i=1 Pm j=1 Pa k=1 b**i,j,a**k
. Additionally, the problem can be formulated as an optimization problem in a constraint solver, using a matrix model with one row for each employee. We post a GRAMMAR constraint on each row, AMONG constraints on each column for labour demand and LEX constraints between adjacent rows to break symmetry. We use the static variable and value ordering used in [4].

We compare this with reformulating the GRAMMAR constraint as a REGULAR constraint. Using algorithm 3, we computed the size of an equivalent NFA. Surprisingly, this is not too big, so we converted the GRAMMAR constraint to a DFA then minimized. In order to reduce the blow-up that may occur converting a NFA to a DFA, we heuristically minimized the NFA using the following simple observation: two states are equivalent if they have identical outgoing transitions. We traverse the NFA from the last to the first layer and merge equivalent states and then apply the same procedure to the reversed NFA. We repeat until we cannot find a pair of equivalent states. We also simplified the original CYK table, taking into account whether the business is open or closed at each slot. Theorem 4 suggests such simplification can significantly reduce the size both of the CYK table and of the resulting automata. In practice we also observe a significant reduction in size. The resulting minimized automaton obtained before simplification is about ten times larger compared to the minimised DFA obtained after simplification. Table 1 gives the sizes of representations at each step. We see from this that the minimized DFA is always smaller than the original CYK table. Interestingly, the subset construction generates the minimum DFA from the NFA, even in the case of two activities, and heuristic minimization of the NFA achieves a notable reduction.

For each instance, we used the resulting DFA in place of the GRAMMAR constraint in both the CP model and the PB model using the encoding of the REGULAR con-