constraints specified by automata and grammars. An automaton A = hΣ, Q, q0**, F, δ**i consists of an alphabet Σ, a set of states Q, an initial state q0, a set of accepting states F, and a transition relation δ defining the possible next states given a starting state and symbol. The automaton is deterministic (DFA) is there is only one possible next state, non-deterministic (NFA) otherwise. A string s is *recognized* by A iff starting from the state q0 we can reach one of the accepting states using the transition relation δ. Both DFAs and NFAs recognize precisely regular languages. The constraint REGULAR(A, [X1**, . . . , X**n]) is satisfied iff X1 to Xn is a string accepted by A [1].

Pesant has given a domain consistency propagator for REGULAR based on unfolding the DFA to give a n-layer automaton which only accepts strings of length n [1].

Given an automaton A, we write **unfold** n(A) for the unfolded and layered form of A that just accepts words of length n which are in the regular language, **min(**A) for the canonical form of A with minimal number of states, **simplify**(A) for the simplified form of A constructed by deleting transitions and states that are no longer reachable after domains have been reduced. We write fA(n) ≪ gA(n) iff fA(n) ≤ gA(n) for all n, and there exist A such that log gA(n)
fA(n) = Ω(n). That is, gA(n) is never smaller than fA(n) and there are cases where it is exponentially larger.

A context-free grammar is a tuple G = h**T, H, P, S**i, where T is a set of *terminal* symbols called the *alphabet* of G, H is a set of *non-terminal* symbols, P is a set of productions and S is a unique starting symbol. A production is a rule A → α where A is a non-terminal and α is a sequence of terminals and non-terminals. A string in Σ∗is *generated* by G if we start with the sequence α = hSi and non deterministically generate α
′ by replacing any non-terminal A in α by the right hand side of any production A → α until α
′contains only terminals. A context free language L(G) is the language of strings generated by the context free grammar G. A context free grammar is in Chomsky normal form if all productions are of the form A → BC where B and C are non terminals or A → a where a is a terminal. Any context free grammar can be converted to one that is in Chomsky normal form with at most a linear increase in its size. A grammar Ga is *acyclic* iff there exists a partial order ≺ of the non-terminals, such that for every production A1 → A2A3, A1 ≺ A2 and A1 ≺ A3. The constraint GRAMMAR([X1, . . . , Xn], G) is satisfied iff X1 to Xn is a string accepted by G [2, 3].

Example 1. As the running example we use the GRAMMAR([X1, X2, X3], G) constraint with domains D(X1) = {a}, D(X2) = {a, b}, D(X3) = {b} and the grammar G in Chomsky normal form [3] {S → AB, A → AA | **a, B** → BB | b}.

Since we only accept strings of a fixed length, we can convert any context free grammar to a regular grammar. However, this may increase the size of the grammar exponentially. Similarly, any NFA can be converted to a DFA, but this may increase the size of the automaton exponentially.

## 3 Grammar Constraint

We briefly describe the domain consistency propagator for the GRAMMAR constraint proposed in [2, 3]. This propagator is based on the CYK parser for context-free grammars. It constructs a dynamic programing table V where an element A of V [**i, j**] is a