straint as a REGULAR constraint may improve propagation speed if it does not require a large transition relation. In addition, we can perform optimizations such as minimizing the automaton. In this section, we argue that reformulation is practical in many cases
(sections 4.1-4.3), and there is a polynomial test to determine the size of the resulting NFA (section 4.4). In the worst case, the resulting NFA is exponentially larger then the original GRAMMAR constraint as the following example shows. Therefore, performing the transformation itself is not a suitable test of the feasibility of the approach.

Example 2. Consider GRAMMAR([X1, . . . , Xn], G) where G generatesL = {wwR|w ∈
{0, 1}
n/2}. Solutions of GRAMMAR can be compiled into the dynamic programming table of size O(n 3), while an equivalent NFA that accepts the same language has exponential size. Note that an exponential separation does not immediately follow from that between regular and context-free grammars, because solutions of the GRAMMAR
constraint are the strict subset of L(G) which have length n.

In the rest of this section we describe the reformulation in three steps. First, we convert into an acyclic grammar (section 4.1), then into a pushdown automaton (section 4.2), and finally we encode this as a NFA (section 4.3). The first two steps are well known in formal language theory but we briefly describe them for clarity.

## 4.1 Transformation Into An Acyclic Grammar

We first construct an acyclic grammar, Ga such that the language L(Ga) coincides with solutions of the GRAMMAR constraint. Given the table V produced by the GRAMMAR
propagator (section 3), we construct an acyclic grammar in the following way. For each possible derivation of a nonterminal A, A → BC, such that A ∈ V [**i, j**], B ∈
V [**i, k**] and C ∈ V [i + **k, j** − k] we introduce a production Ai,j → Bi,kCi+k,j−k in Ga (lines 11- 17 of algorithm 1). The start symbol of Ga is S1,n. By construction, the obtained grammar Ga is acyclic. Every production in Ga is of the form Ai,j →
Bi,kCi+k,j−k and nonterminals Bi,k, Ci+k,j−k occur in rows below jth row in V . Example 3 shows the grammar Ga obtained by Algorithm 1 on our running example.

Example 3. The acyclic grammar Ga constructed from our running example.

$$\begin{array}{c c c c}{{S_{1,3}\to A_{1,2}B_{3,1}\mid A_{1,1}B_{2,2}}}&{{}}&{{A_{1,2}\to A_{1,1}A_{2,1}}}&{{}}&{{B_{2,2}\to B_{2,1}B_{3,1}}}\\ {{}}&{{}}&{{A_{i,1}\to a_{i}}}&{{}}&{{B_{i,1}\to b_{i}}}&{{}}&{{\forall i\in\{1,2,3\}}}\end{array}$$

To prove equivalence, we recall that traces of the table V represent all possible derivations of GRAMMAR solutions. Therefore, every derivation of a solution can be simulated by productions from GA. For instance, consider the solution (**a, a, b**) of GRAMMAR from Example 1. A possible derivation of this string is S|S∈V [1,3] →
AB|A∈V [1,2],B∈V [3,1] → AAB|A∈V [1,1],A∈V [2,1],B∈V [3,1] → aAB|... → aaB|... →
aab|.... We can simulate this derivation using productions in Ga: S1,3 → A1,2B3,1 → A1,1A2,1B3,1 → a1A2,1B3,1 → a1a2B3,1 → a1a2b3.

Observe that, the acyclic grammar Ga is essentially a labelling of the AND/OR
graph, with non-terminals corresponding to OR-NODES and productions corresponding to AND-NODES. Thus, we use the notation Ga to refer to both the AND/OR graph and the corresponding acyclic grammar.