consider compositions of lexicographical ordering and problem constraints. We conjecture that the additional pruning achieved by combining together symmetry breaking and problem constraints will justify the additional cost of propagation. In support of this, we present a simple problem where it gives a super-polynomial reduction in search. We also implement these new propagators and run them on benchmark nurse scheduling problems. Experimental results show that propagating of a combination of symmetry breaking and global constraints reduces the search space significantly and improves run time for most of the benchmarks.

## 2 Background

A constraint satisfaction problem (CSP) P consists of a set of variables X = {X[i]}, i = 1**, . . . , n** each of which has a finite domain D(X[i]), and a set of constraints C. We use capital letters for variables (e.g. X[i] or Y [i]), lower case for values (e.g. v or vi) and write X for the sequence of variables, X[1] to X[n]. A constraint C ∈ C has a *scope*, denoted scope(C) ⊆ X and allows a subset of the possible assignments to the variables scope(C), called solutions or *supports* of C. A constraint is domain consistent (DC) iff for each variable X[i], every value in the domain of Xi belongs to a support. A solution of a CSP P is an assignment of one value to each variable such that all constraints are satisfied. A matrix model of a CSP is one in which there is one (or more) matrices of decision variables. For instance, in a rostering problem, one dimension might represent different employees and the other dimension might represent days of the week.

A common way to solve a CSP is with backtracking search. In each node of the search tree, a *decision* restricts the domain of a variable and the solver infers the effects of that decision by invoking a *propagator* for each constraint. A propagator for a constraint C is an algorithm which takes as input the domains of the variables in **scope**(C)
and returns *restrictions* of these domains. We say the a propagator enforces *domain* consistency (DC) on a constraint C iff an invocation of the propagator ensures that the constraint C is domain consistent.

A *global constraint* is a constraint in which the number of variables is not fixed. Many common and useful global constraints have been proposed. We introduce here the global constraints used in this paper. The global lexicographical ordering constraint LEX(X, Y ) is recursively defined to hold iff X[1] < Y [1], or X[1] = Y [1] and LEX([X[2], . . . , X[n]], [Y [2], . . . , Y [n]]) [5]. This constraint is used to break symmetries between vectors of variables. The global sequence constraint SEQUENCE(l, u, k, X, V ) holds iff l ≤ |{i | X[i] ∈ V, j ≤ i < j + k**}| ≤** u for each 1 ≤ **j < n** − k [6]. The regular language constraint REGULAR(A, X) holds iff X[1] to X[n] takes a sequence of values accepted by the deterministic finite automaton A [7].

The last two constraints are useful in modeling rostering and scheduling problems.

## 3 The C&Lex Constraint

Two common patterns in many matrix models are that rows of the matrix are interchangeable, and that a global constraint C is applied to each row. To break such row symmetry, we can post constraints that lexicographically order rows [4]. To improve 2