Boolean case, we can exploit properties of the filtering algorithm for the SEQUENCE constraint (**HP RS**) proposed in [9]. The core of the **HP RS** algorithms is the CheckConsistency procedure that detects inconsistency if the SEQUENCE constraint is unsatisfiable and returns the lexicographically smallest solution otherwise. The HP RS algorithm runs CheckConsistency for each variable-value pair Xi = vj . If CheckConsistency detects a failure, then value vj can be pruned from D(Xi), otherwise CheckConsistency returns the lexicographically smallest support for Xi =
vj . As was shown in [9], the algorithm can be modified so that CheckConsistency returns the lexicographically greatest support. Both versions of the algorithm are useful for us. We will use the min subscript for the first version of the algorithm, and the max subscript for the second.

Due to these properties of the **HP RS** algorithm, a propagator for the C&LEX
(X, Yu, SEQUENCE)lb, denoted HP RS′min(X, Yu), is a slight modification of HP RSmin, which checks that the lexicographically smallest support for Xi = vj returned by the CheckConsistencymin procedure is lexicographically smaller than or equal to Yu. To find the lexicographically greatest solution, Yu, of the SEQUENCE(Y ) constraint, we run CheckConsistencymax on variables Y . Dual reasoning is applied to the C&LEX(Xl, Y , SEQUENCE)ub constraint. Algorithms 5 shows pseudo code for DC propagator for the C&LEX(X, Y , SEQUENCE) constraint.

Algorithm 5 C&LEX(X, Y , SEQUENCE)

1: **procedure** C&LEX(X : out, Y : **out,** SEQUENCE (l, u, k) : in)

2: if ¬(CheckConsistencymin(Xl, X)) or ¬(CheckConsistencymax(Y , Yu)) **then**

3: return **false**;

4: if (Xl >lex Yu) **then**

5: return **false**;

6: HP RS′max(Xl, Y , SEQUENCE(**l, u, k**)); 7: HP RS′min(X, Yu, SEQUENCE (**l, u, k**));

HP RS′min and HP RS′max are incremental algorithms, therefore the total time

![0_image_0.png](0_image_0.png)

![0_image_1.png](0_image_1.png)

complexity of Algorithm 5 is equal to the complexity of the **HP RS** algorithm, which is O(n 3) down a branch of the search tree. Correctness of Algorithm 5 follows from Proposition 1 and correctness of the **HP RS** algorithm.

Example 3. Consider the SEQUENCE(2, 2, 3, [X[1], X[2], X[3], X**[4]])** and SEQUENCE(2, 2, 3, [Y [1], Y [2], Y [3], Y **[4]])** constraints. The domains of the variables are X = [{0, 1}, {1}, {0, 1}, {0, 1}] and Y = [{0, 1}, {0, 1}, {1}, {0, 1}]. Note that each of the two SEQUENCE and the LEX(X, Y ) constraints are domain consistent.

The C&LEX(X, Y , SEQUENCE) constraint fixes variables X to [0, 1, 1, 0]. The lexicographically greatest solution for the SEQUENCE(Y ) is [1, 0, 1, 0], while the lexicographically smallest support for X**[1] = 1** is [1, 1, 0, 1]. Therefore, the value 1 will be pruned from the domain of X[1]. For the same reason, the value 0 will be pruned from X[3] and the value 1 will be pruned from X[4].

Consider the general case, where X and Y are finite domain variables. We can channel the variables X, Y into Boolean variables bX,bY and post SEQUENCE(bX),