SEQUENCE(bY ), which does not hinder propagation. Unfortunately, we cannot post the LEX constraint on the Boolean variables bX and bY , because some solutions will be lost. For example, suppose we have SEQUENCE(X, 0, 1, 2, {2, 3}) and SEQUENCE(Y , 0, 1, 2, {2, 3}) constraints. Let X **= [2**, 0, 2] and Y **= [3**, 0, 0] be solutions of these constraints. The corresponding Boolean variables are bX **= [1**, 0, 1] and bY **= [1**, 0, 0]. Clearly X <lex Y , but bX >lex bY . Therefore, the LEX constraint can be enforced only on the original variables.

The problem is that the **HP RS** algorithm returns the lexicographically smallest solution on Boolean variables. As the example above shows, lexicographical comparison between Boolean solutions of SEQUENCEs bX and bY is not sound with respect to the original variables. Therefore, given a solution of SEQUENCE(bX), we need to find the corresponding lexicographically smallest solution of SEQUENCE(X). We observe that if we restrict ourselves to a special case of SEQUENCE(**l, u, k, v,** X) where max(D \ v) < **min(**v) then this problem can be solved in linear time as follows. Let bX be a solution for SEQUENCE(bX). Then the corresponding lexicographically smallest solution X for SEQUENCE(X) is X[i] = min(v ∩ D(X[i])) if bX[i**] = 1**
and X[i] = min(D(X[i])) otherwise. In a similar way we can find the corresponding lexicographically greatest solution. A slight modification to Algorithm 5 is needed in this case. Whenever we need to check whether bX is smaller than or equal to bY , we transform bX to the corresponding lexicographically smallest solution, bY to the corresponding lexicographically greatest solution and perform the comparison.

## 3.3 The C&Lex(**X, Y ,** Regular) Constraint

With the REGULAR(A, X) constraint, we will show that we can build a propagator for C&LEX which takes just O(nT ) time, compared to O(n 2T ) for our general purpose propagator, where d is the maximum domain size and T is the number of transitions of the automaton A. We will use the following example to illustrate results in this section. Example 4. Consider the C&LEX(X, Y , C) constraint where the C is REGULAR(A, X) and A is the automaton presented in Figure 1. Domains of variables are X[1] ∈ {1, 2}, X[2] ∈ {1, 3}, X[3] **∈ {2}** and Y [1] ∈ {1, 2, 3}, Y [2] ∈ {1, 2}, Y [3] ∈ {1, 3}.

![0_image_0.png](0_image_0.png)

