
## 5.1.1   The Need For Non Standard Reasoning

As we already mentioned, sometimes it turns out difficult to make non ambiguous decisions on some particular cases in absence of specific knowledge about the learner as mentioned in the example in [45]. The question makes sense in a dynamic situation, like the following question implies: how to dynamically judge the complexity of an exercise, statically assumed by its author to assess a particular classification, let us say, P × K, if the applier (the student)
does not have yet reached level K at the knowledge dimension. What can we conclude in such a case?

Such a kind of question is evidently relevant in the e-Learning context, for instance, preparing an appropriated response for an exercise interaction, as we had mentioned before. For such a case, we might hypothesize some explicit rules to be used and added to Bloom's framework, which we call non-standard. For instance, like the following claim:
If student exhibits knowledge on a level less than K and the exercise statically assumes P × K then the dynamic complexity becomes Create × K. In other words, the exercise requires students to create knowledge of level K
in order to perform P.

It is interesting that such a rule can be geometrically interpreted as moving the complexity to the last cell of the row K, which is the one with the highest skill requirements.

Evidently, it might be debatable whether such a kind of reasoning is empirically valid or not. The point we want to make is that a Bloom's based methodology would need to contemplate similar forms of reasoning when used in a dynamic way as we may have modeling interactions between exercises and students.  We identify this as an important open question.

## Bloom'S Taxonomy And Cs1 5.2

As a case of study, we want to review the way [32, 33] uses Bloom's Taxonomy in CS1.

In this case, it is an object-first course using Java and where no e-Learning is directly considered. Basically, the main purpose is to define more realistically the course objectives and from there to implement a more aligned grading system 12 .  The author explicitly avoids performing a detailed explicit one-by-one mapping of his statements to the categories of the taxonomy. Instead, he proposes three general complexity categories which are considered adequate to his CS1 vision and empirical considerations. The proposal is shown in Table 313 ,
The objectives of CS1 under this model are defined to address the first two categories, only.

Thus, we realize that this model pays special attention to develop reading and understanding skills. In fact, that is sufficient for passing it, according to the grading model. The second category is meant as writing code in a well-defined context.

Consequently with this decision, we want to understand it as providing well-defined specifications referring to a domain fully understood by the learner. This should include the appropriate class structure, the signatures and finally the methods should be kept 12 The original version of the taxonomy is used and as a consequence only the cognitive process dimension 13 Identifying Bloom's original categories with the verbs used in the revised version one-by-one