At least, there seems to exist consensus on some of the main issues associated with former and current teaching approaches. For instance, in terms of:
- Expected levels of quality from an academic perspective
- IT labor market demand and technical requirements

- Student individual motivation for taking a computing discipline as a career (student attraction and retention)
These **dimensions** of learning trigger forces which might naturally compete with each other so the particular teaching approach tends to mirror that in one way or another. Therefore, we should not completely ignore them in our analysis.

In fact, contextual considerations of that kind indicate we have enough good reasons for innovation through e-Learning techniques at any, at some or even all the mentioned dimensions.

We believe that any e-Learning approach concerning some key facet of the learning how to program (especially one considered so crucial like programming exercises) should not be designed ignoring some issues related with these forces. Hence, we would consider rather important to try to understand in more detail some of the key technical issues within the debate (for instance, the question *of the right* programming paradigm and the transition CS1-CS2 under the *functions-first* model, [1]). To a certain extent, we have tried to incorporate them, at least indirectly, in the background of our analysis.

However, and given the limited scope of this research, we decided to focus on cognitive models of programming in a way that can help us understand more formally why exercise are considered *'hard'* for novices (we use [5, 15, 25, 30, 34, 32, 43, 49] and [23] as a general and standard reference). We address the question within the frame of e-Learning.

We do not consider socio-motivational ([18, 21]) or market related concerns ([37]), and in order to understand a relative small part of the entire problem, we do it in the context of a particular CS1 instructional material just as a case study. Through this input, we try to raise some questions on how such *complexity* is reflected and can be recognized on exercise instances by using a hopefully cognitively adequate and sound set of reasoning criteria.

For such a purpose, we mainly follow approaches based on or quite related to Bloom's Taxonomy ([2]) because it is a simple yet powerful framework which has been applied in CS1 related questions with apparently quite interesting results ([27, 33, 32, 18, 45]).

We interprete such experiences found in the literature as a sound basis to understand the complexity of some class of exercises as a part of an e-Learning environment. Through our work, we identify interesting questions concerning representation and formal reasoning and contribute with conceptual proposals to deal with them. We consider the ActiveMath model of exercise ([17, 50]) as a point of reference to derive from there our requirements on representation and manipulation languages in terms of a potential implementation.