
## Introduction

We are interested in the general problem of how to take advantage of an e-Learning framework (like [36]) as a target for adequately coding programming exercises of the kind we might encounter at a traditional CS1 course level ([1]). In such a situation, a core problem to deal with is how static learning programming material (books, exercises, examples, etc.), whose dynamics (feedback, diagnosis, guidance, etc.) mainly takes place at classroom or labs or through personal interactions, can be implemented as active e-Learning content. In such a way that an important part of the dynamics can become an active component of the corresponding e-Learning version. At this work, and from a very particular point of view, we want to contribute to the understanding of some parts of the problem by identifying requirements and proposing solution paths at a concrete level.

In addition, we also consider important to account for reasons and issues at the contextual level because they may have an impact on our understanding of the problem helping us to reflect upon scope, relevance, feasibility and potential benefits of alternative approaches to solution paths. And even tough our work is limited we want to situate it within a practical context and make explicit where it pretends to fit in and where it does not.

Let us begin saying that it is not difficult to become attracted by the potential benefits that e-Learning might offer from the point of view of curricula, in general. We may think about things like extensive and massive availability of educational material via the Web and rich electronic media, active course administration, maintenance and application among many other evident advantages which extend the scope of a more traditional classroom oriented model. Hence, given a particularly effective approach to teach programming, it sseems quite reasonable to try to delivery it with the help of some e-Learning strategy, expecting this way to profit from its benefits at some appreciable degree. To define an adequate strategy for delivering programming is evidently an important and sensitive first stage to take into consideration.

When establishing such an objective at the CS1 level, indirectly and unavoidably, we come across the well-known debate around what is the most appropriate way to teach programming for novices at Computer Science (CS) and Information Technology (IT) related disciplines, where programming is considered in their curricula an essential skill ([1]). For answering such a question a lot of conceptions, models and tools have been presented in the past and the discussion still remains open nowadays (for a small subset where different perspectives and issues are discussed see [1, 32, 26, 18, 21, 35, 37, 38, 39]).

Issues in the dispute cover the proper abstract nature of the subject, the definition of minimal programming skills, the programming paradigm, the programming language, the convenience or not of using tools, the approach to motivation and course situation among many others. Such a wide spectrum and space for divergence shows us that the subject CS1 turns out difficult to normalize even though it is technologically, scientifically and socially quite relevant, given the CS/IT impact on many societies.

## 1
