Perhaps the source of such a potential inconsistency, if there is any, could be recognized during the authoring phase of an exercise. Popular cognitive models, like Bloom's Taxonomy, and their interpretations in the programming field, are useful frameworks that can help instructors and teachers to reason about that kind of issue. Hence, in a CS1 or similar e-Learning context, it would certainly be interesting that the computational representation of exercises would allow semiautomated reasoning at that level. The situation we have in mind would be one where some sort of analysis of exercises could be performed in a *static* way during the authoring stage; eventually warning for potential *cognitive inconsistencies*, as in example in Figure 1.

At this point and just briefly, we like to relate our goal of checking consistency with the approach of the so-called *buggy rules* ([50]). As we will explain later on, our goal to have a reasoning procedure about exercises can be seen as a technique that would allow to suggest whether something like buggy rules might be required at some point in a given exercise specification. Another related case employing something similar to the notion of buggy rules is [40]. In both cases, we realize that a key to take into account in our analysis is a domain reasoner on programming exercises. Such a reasoner should allow us to express exercise playing as in [50] but also additional requirements like reasoning on the exercise itself would then be possible. For instance, in terms of exercise complexity, design and reuse, as we explain in more detail later on.

## 3 Structure Of The Rest Of The Paper

The rest of this report is organized as follows. In Section 4 we present the background on which we base the study. In general, the idea is to review the material looking for requirements according to the scope and goals of the work. We cover definitions and models for CS1 in order to obtain contextually relevant feedback. We also analyze e-Learning and the features and facilities of ActiveMath which are most related with the exercise subsystem. We pay special attention to the idea of a domain reasoner from a conceptual perspective. Then, we address Bloom's Taxonomy and focus on its computational interpretation as a framework for semantic based informal reasoning. We present some cases of study where the taxonomy has been applied for CS1 courses.

In Section 6 we recapitulate the identified requirements and reformulate them as a kind of agent interaction system, in a simplified but useful way. This allows us to derive a conceptualization by means of a three-layered reasoning model. We then show how this architectural model could be used to represent exercise operations and its relation to the requirements of a domain reasoner adequate for programming. Finally, in Section 7 we illustrate how our model can be used for reasoning about complexity and also we summarize some open problems for further research. And finally, in Section 8 we summarize and give conclusions pointing to future work.