The structure of this domain specific rule lets us formulate a recursive solution plan for a task matching d[f(g(x))]
dx which includes solving both intermediate tasks d[f(z)]
dz (g(x)) (outer layer) and d[g(x)]
dx (inner layer).

For instance, d[log(sin(x 3
))]
dx is a matching task that evidently reduces using Rule (1) to d[log(z)]
dz (sin(x 3))
and d[sin(x 3
]
dx as recursive subtasks.

Additionally, incorrect (buggy) rules can be known and applied by the expert reasoner to identify potential wrong steps like the following when the inner derivation step d[g(x)]
dx is missing:

$${\frac{d[f(g(x))]}{d x}}\Rightarrow_{\{b u g g y,c h a i n r u e,i n n e r_{-l a y e r}\}}{\frac{d[f(z)]}{d z}}(g(x))$$
$$\left(2\right)$$

dz (g(x)) (2)
In the example below, such a buggy rule would account for explaining some wrong answer from a student, for example like 1 sin(x3)
as an answer for d[log(sin(x 3
))]
dx .

That kind of rules allows the response module to report a missing inner layer as a possible cause of the wrong or incomplete answer.

We also notice that a DR also needs to make use a at lower-level of other tools for symbolic manipulation like a computer algebra system (CAS). For example, to compare symbolic expressions not only syntactically but also using their normal forms. In the same direction, a matching operation associated with a rule selection can be more involving, because in case some previous symbolic transformation is required to allow a syntactic matching and rule application. Think of AC-matching for instance.

Robinet (et al) reports in [40] a dynamic model to identify so-called *intermediate metal steps* when solving linear equations and inequations like for instance 2x + 9 = 8 + 6x (the target e-Learning system is **APLUSIX**). In this case, domain rules include moving monomials from one side of equation to the other and algebraic calculations. Notice that rule selection is don't care non-deterministic. If a student would wrongly response, let us say, with 8x = 17 then the model attempts to find the most probable path (a combinations of movements and calculations) explaining the error. Such a path is then used for tuning a student model and diagnosis (for instance, to detect whether student has more problems with movements or with calculations or both).