
## 5 On Bloom'S Taxonomy

We briefly review Bloom's Taxonomy as a standard framework for analyzing educational objectives and this turns to be useful for answering questions concerning exercise complexity, in particular. We restrict the presentation to the cognitive taxonomy. We will use the revised version as presented in [2], which is two-dimensional. We believe that it is adequate in our context where procedural programming skills and knowledge are both relevant. We cover the material using similar notions as in conceptual modeling and semantic based reasoning ([7]). The reason is that the taxonomy could be conceived as a procedure for formal reasoning on semantic complexity of exercises.

## 5.1 Basic Notions

Expressed in our biased computational and simplified perspective, Bloom's Taxonomy is basically an empirical reasoning framework. It deals with the classification of statements representing objectives, goals and tasks we want someone to achieve and accomplish. Classification is twodimensional. In principle, it can be used with statements referring to any domain. It is strongly human-oriented, statements are expressed in natural language and consequently ambiguity can be a problem, as one might expect 11. Once educational statements get classified, expert based recommendations (a kind of expert rules) can be used to associate the classification with recommendations about best practices in terms of organizing learning priorities, instruction delivery, assessment and alignment, roughly speaking.

The classification procedure is described as a matrix (See Table 2 for an illustration). Rows represent the *knowledge dimension* with four categories: Factual, Conceptual, *Procedural* and Metacognitive. Columns represent the *cognitive process dimension* where six categories are considered: Remember, Understand, Apply, Analyze, *Evaluate* and *Create*. In both cases, a dimension represents a continuum of complexity. Categories in a dimension identify specific ordered points over this continuum. For instance, *Apply* is more complex than *Remember* as a cognitive process. And *Conceptual* is more complex than *Factual* as knowledge. Over this last dimension, complexity usually contrasts concreteness against abstractness, with *Factual* being more concrete than the others.

![0_image_0.png](0_image_0.png)

In order to classify a statement, the procedure first requires us to *normalize* it by putting it in