
## Ii. Emotionally Annotated Databases

Annotated databases have simple yet effective structure. 

They typically consist of a file system conjoined with a corresponding manifesto that enumerates and describes all files in the database. The manifesto is a simple text, CSV 
(comma-separated value) or any other easily readable file in which each row describes one singular piece of data. Often only one manifesto carries all metadata, but it is possible to add more manifests and cross-link them if needed. Data rows are guaranteed unique and although primary or foreign keys aren't explicitly declared an annotated database can be transformed into a relation database. In the case of IAPS or IADS the value of the primary key can be the name of the stimuli file which is always an unique four digit number, e.g. 5999.jpg, 6000.jpg, 100.wav, 101.wav, etc. The files have URI 
(Uniform Resource Identificator) which makes it easy to fetch them and use programmatically. Such design principles and nomenclature make annotated databases technologically rudimentary by today's standards, but for the same reasons also robust and good cross-platform solutions. 

Emotional annotated databases, e.g. IAPS or IADS, use storage mechanisms which are generic to all annotated databases, but with the single purpose of aggregating emotional content. IAPS and IADS store emotional content according to the quantitative-dimensional psychological model. This model numerically describes the meaning of the emotional impulse in a 2D plane with the respect to the axis of valence or pleasure (x-axis; denoted pl) and the axis of excitation or arousal (y-axis; denoted ar). Values of both axis are normalized in interval [1, 9]. Fig. 1. shows IAPS data projected on the referent 2D plane with each dot representing one emotionally annotated picture. 

![0_image_2.png](0_image_2.png)

The semantic context of the stimuli in such model is described with a closed set of keywords. One stimulus is always tagged with one keyword. In other words, all IAPS 
and IADS stimuli have to be tagged, but with no more than one keyword. Fig. 2. displays 4 stimuli that are tagged with the keyword *Boat*. 

![0_image_0.png](0_image_0.png)

Quantitative-dimensional models correlate better with biological-emotional changes then discrete categorical models which categorize emotions in slots such as joy, sadness, surprise, disgust, fear and anger. For these reasons, quantitative-dimensional models are considered to be suitable for describing motive in psychotherapy and psychological training where is necessary to control the emotional physiology of a subject with stimuli. An example of annotated visual emotional stimuli from IAPS 
with (*pl, ar*) = {(5.59, 2.88), (5.34, 4.23), (7.48, 4.74), (7.53, 5.94)} and semantics defined with the keyword *Boat* are shown in Fig. 3. 

One of the biggest challenges when working with emotionally annotated databases IAPS and IADS is construction of scenarios in psychotherapy and psychological training. The scenarios have to be consistent and individually tailored for specific subjects and point in their therapy. Also, extraction of stimuli from databases has to be accurate, simple and fast. All these issues directly contribute to the quality of generated scenarios and success of their use. 

![0_image_1.png](0_image_1.png)

Content and purpose of scenarios in psychotherapy and psychological training can be defined only through harvesting individual emotional stimuli. Meaning of the scenario is an aggregation of semantics of all stimuli included in the scenario. In emotionally annotated databases semantics is exclusively encoded in stimuli keywords. However, distribution of keywords in IAPS and IADS databases with the respect to the stimuli is sparse and the structure is often inconsistent. Table 1 shows important statistical data on IAPS and IADS databases. 