TABLE I 
IAPS and IADS emotionally annotated databases statistics 

| Feature                          | IAPS   | IADS   |
|----------------------------------|--------|--------|
| value                            | value  |        |
| Num. of stim.                    | 957    | 168    |
| Num. of keywords                 | 491    | 166    |
| Max. stim. per 1 keyword         | 32     | 2      |
| Num. of keywords with 10+ stim.  | 13     | 0      |
| Num. of keywords with 6-10 stim. | 10     | 0      |
| Num. of keywords with 4-5 stim.  | 28     | 0      |
| Num. of keywords with 2-3 stim.  | 100    | 2      |
| Num. of keywords with 1 stim.    | 346    | 164    |
| Avg. num. of stim. per 1 keyword | 1.949  | 1.006  |
| Mode of stim. per 1 keyword      | 1      | 1      |
| Median of stim. per 1 keyword    | 1      | 1      |
| Std.dev.                         | 2.815  | 0.134  |

As can be seen in Table 1 the most well-known emotionally annotated databases (IAPS and IADS) have relatively many keywords compared to number of stimuli. This is especially noticeable in IADS statistics. In IAPS there is on average just 1.95 stimuli per single keyword. 

Median and mode measures of this ratio are both 1. Only 13 keywords define semantics for 10 or more stimuli, and 346 keywords define semantics for 1 stimulus. Distribution of stimuli per keywords in IADS is even more inept because almost every stimulus is described with its own unique keyword. 

This data unequivocally shows the prevalence of describing stimuli semantics with unique keywords. Since keywords aren't semantically cross-linked in any machinereadable mode, semantics discovery is difficult. In their original form annotated databases demand a human expert that is well versed in their structure, emotional and semantic content. 

## Iii. Tags And Folksonomies In Emotionally Annotated Databases

After examining emotionally annotated databases it becomes clear that the biggest problems in describing stimuli semantics with free-text keywords are: 1. Inconsistency 2. Ambiguity 3. Non-contiguousness Inconsistency is demonstrated in various ways. For example simultaneous use in IAPS of singular and plural forms of the same semantic concept like with keywords Woman/Women, *Baby/Babies, Soldier/Soldiers* , or in concatenation of an adjective form and a noun, a noun and a verb, or even two nouns like in *AngryFace*, 
GrievingFem, ManInPool, BoysReading, *Girl&Dog*, etc. There is also simultaneous use of different terms in annotation of the same concept as in *Woman*, Fem and a suffix *–fem*, and lexical or appellation inconsistencies like Cliffdiver and *CliffDivers*, or *MenW/guns*. In addition to problems already mentioned there are incoherent pluralities and meanings like in *BikerCouple, Biking/train,* NeuMan, NeutGirl, NeutralGirl, NeuWoman, etc. 

Ambiguity is a consequence of semantic inconsistency of the keywords. By analyzing IAPS and IADS tags it is not possible to make a unanimous decision whether some concepts are identical or different. Equally, it is impossible to numerically describe their mutual likeness. The tags do not provide enough information to completely describe and successfully discriminate stimuli semantics. 

Non-contiguousness is also a consequence of the inconsistency. It is very difficult to define connections between IAPS tags based on their meaning, but as can be seen in the examples much if not all inconsistency could be avoided by storing nouns and verbs as unique concepts and assigning adverbs, adjectives and pluralities as their properties. Concepts could be conjoined with unary or binary operators (i.e. NOT, AND, OR, etc.) and formed into well-formed sentences. This ontological structure could be then used for automated reasoning by knowledge extraction with queries executed on the dataset. 

Since emotionally annotated databases like IAPS and IADS are professionally recognized and widely used tools, it is important to also consider their keywords in the aspect of social indexing. Because these databases are used among different research groups it is plausible that at least some groups would like to modify tags or define their own tag sets. This would lead to new semantics and subsequently to the introduction of folksonomies [7]. Currently IAPS and IADS databases are not capable of supporting collaborative tagging: semantics of each stimulus is described with only one keyword, sets of stimuli and keywords are constant, and there is no mechanism or application that enables social tagging. Introduction of folksonomies in emotionally annotated databases would bring quantitatively and qualitatively better expressivity of stimuli semantics. This would improve the psychotherapy and psychological training and alleviate workload of the system's supervisor. 

![0_image_0.png](0_image_0.png)

Another benefit of describing visual or auditory (i.e. 

multimedia) stimuli with multiple tags is a more accurate description of stimuli semantic content. An example is Fig. 