Dublin Core metadata element set [12] for description of stimuli resource files. Image, sound or video files are a part of emotionally annotated databases, however their properties such as title, creator, subject, description, contributor, create date, type and format are unknown or must be derived implicitly. For example: IAPS stimulus 4000.jpeg has identification *4000*, its type derives from the stimulus' extension as *image/jpeg* and its description is hard-coded in the CSV manifesto file as *Artist*. As can be seen this resource information is sparse and it makes little contingencies for collaborative or cross-domain exchange. 

Since Dublin Core metadata element set is a standard for cross-domain information resource description it can ensure simple and standardized set of conventions for description of resources in emotional annotated databases such as IAPS and IADS. 

Fig. 8 demonstrates one proposal on how to encode information about one resource in RDF format; dc:identifier tag is used to store stimulus unique name and dc:subject its free-text keyword or keywords, *dc:type* describes the content of the resource by indicating emotionally annotated database to which the stimulus belongs, *dc:creator* refers to a person or body responsible for the content of the resource, *dc:contributor* is a person or entity responsible for making contributions to the content of the resource, *dc:date* is associated with an event in the lifecycle of the resource, and finally *dc:format* designates digital manifestation of the resource. 

Fig. 8. Simple level of Dublin Core metadata elements in 

![0_image_0.png](0_image_0.png)

![0_image_1.png](0_image_1.png)

![0_image_2.png](0_image_2.png)

description of IAPS stimulus *4000*. 

## Vi. Conclusion

Current methods of content description in emotionally annotated databases have a low level of expressivity and accuracy. Indeed, there are many better paradigms for data storing and extraction which are used in other areas of computing such as relational databases or data warehouses. However, the best knowledge description procedures for the task of eliciting emotional response must be not only informatively rich but also self-explanatory and technically simple. Ontology is an excellent solution to this problem because by its definition [9] it represents a formal explicit specification of a shared conceptualization. It presents a shared understanding of knowledge structure and a common language between human experts and intelligent agents. Also, ontology facilitates its own reuse. 

We started by augmenting predefined free-text keywords with folksonomies and broadening them to tag clouds, but we found ontology to be as yet the best tool for describing and harvesting information in emotionally annotated multimedia resources. 

The future work will include knowledge description in video stimuli and improvement of the existing ontology through cooperation with domain experts, i.e. psychiatrists and psychologists. Our desire is to construct a common ontology that can be used for description of stimuli content in IAPS, IADS or any other *ad hoc* emotionally annotated database, regardless of its resource format - image, sound, video or even synthetic and VR environments. Such versatile StimGen can become a useful tool for the therapist for delivering multimedia stimuli to the patient during psychotherapy. We will also continue our work on integrating StimGen into the entire physiology-driven adaptive VR system for psychotherapy and psychological training. 

## References

 [1] Merriam-Webster Dictionary, Merriam-Webster Dictionary website, 2009. (Retrieved from http://www.merriam-webster.com/dictionary/annotation/ on January 16th 2009.) 
 [2] H. L. Kim et al., "The State of the Art in Tag Ontologies: 
A Semantic Model for Tagging and Folksonomies", Proc. of the 2007 ACM symposium on Applied computing, 2008. 

 [3] S. Golder et al., "Why do tagging systems work?". *CHI '06* Extended Abstracts on Human Factors in Computing Systems, p. 36-39, 2006. 

 [4] K. Ćosić, S. Popović, T Jovanović, D. Kukolja, M. Slamić, 
"Physiology-Driven Adaptive VR System: Technology and Rationale for PTSD Treatment", *Annual Review of* CyberTherapy and Telemedicine, vol. 5, p. 179-191, 2007. 

 [5] S. Popović, K. Ćosić, M. Slamić, "Scenario SelfAdaptation in Virtual Reality Exposure Therapy for Posttraumatic Stress Disorder", *Novel Approaches to the* Diagnosis and Treatment of Posttraumatic Stress Disorder, IOS Press, p. 135-147, 2006. 

 [6] S. Popović, M. Horvat, K. Ćosić, "Generator of audio and visual stimuli for psychotherapy and psychological training", *Third Croatian symposium on stress-related* disorders, p. 40-40, 2008. (in Croatian) 
 [7] J. Voss, "Tagging, Folksonomy & Co - Renaissance of Manual Indexing?", *Proceedings of the International* Symposium of Information Science, p. 234-254, 2007. 

 [8] P. Schmitz, "Inducing Ontology from Flickr Tags", 
Workshop on Collaborative Web Tagging, 2006.

 [9] T. Gruber, "A Translation Approach to Portable Ontology Specifications ", *Knowledge Acquisition,* vol. 5(2), p. 199220, 1993. 

[10] C. Fellbaum, "WordNet: An Electronic Lexical Database", 
MIT Press, 1998. 

[11] I. Horrocks, P. F. Patel-Schneider, F. van Harmelen, "From SHIQ and RDF to OWL: The Making of a Web Ontology Language ", *Journal of Web Semantics,* vol. 1(1), p. 7-26, 2003. 

[12] D. Hillmann, "Using Dublin core. Recommendation", 
Dublin Core Metadata Initiative, 2001. 