
## 5.1 Compiling Constants, Variables And Hard Constraints

Compilation involves replacing stochastic variables by their possible values, and decision variables by a ragged array of decision variables, one for each possible scenario. Constants that depend on stochastic variables also require ragged arrays. We identify positions in the scenario tree by the stage (e.g. first stage, or second stage) and by an ordering over the states at this stage. We therefore declare:
struct AStruct {
AStageRange stage; int state; };
where AStageRange **is a stage index range and is extracted from the stochastic variable declaration.**
By means of this structure, the relevant <stage, state> **pairs are declared:**
{AStruct} Nodes = { <stage,state> | stage in AStageRange & state in 1..nbNodes[stage] };
where nbNodes[stage] **array denotes the number of states at the beginning of each stage and is** extracted from probability data.

To build the certainty equivalent model using the notion of scenarios, a matrix ScenTree **is declared**
and a reference to each node is made via <stage,ScenTree[stage,scen]> where scen denotes a scenario. Variable and constant compilations are performed by means of <**stage,ScenTree[stage,scen]**>
notation and the following rules:
- *Constants with No-Stochastic Dependence*:
Constants declared as independent of stochastic variable, **are not altered.**
- *Constants with Stochastic Dependence*:
In the compiled model, in each stage for each random realization, there should be a unique value of each constant with stochastic dependence. This is achieved by replacing constants C[...,t,...]^R with C[...,<t,ScenTree[t+1,scen]>,...] where t stands for the stage index.

- *Variables with No-Stage Index* :
9
For each scenario there should be a unique decision variable. Therefore, a decision variable without a stage index, X[ind1,...,indn], is replaced with X[ind1,...,indn**,scen]**.

- *Variables with Stage Index* :
Stage indexed variables are modified the same way as constants that depend on the stochastic variable: X[...,<t,ScenTree[t,scen]>,...] replaces **X[...,t,...]**.

Once the variables and constants are transformed and the range of possible scenarios, **Scenarios**, is determined then the compilation of stochastic hard constraints into equivalent deterministic ones requires only a forall statement to cover all possible scenarios: **forall(scen in Scenarios)** { all constraints };
The following financial planning example (see section 8.1 for the problem description), with a stage range 1..N**, demonstrates the application of compilation rules. A mathematical formulation of** the problem, and corresponding stochastic and certainty-equivalent OPL representations thereof are