forall (p in Periods)
sum (scen in 1..nbNodes[p+1])
(Stock[<p+1,ScenTree[p+1,scen]>] >= 0)*Probability[<p+1,scen>] >= ServLev; Note that the bracketing of the inequality reifies the constraint so that it takes the value 1 if satisfied and 0 otherwise.

## 5.3 Compiling Objective Functions

The most common objective function type, the expected value **function, is incorporated into Stochastic**
OPL with the reserved word expected and can be compiled into standard OPL the same way as **prob**:
maximize expected(<Expr>)
compiles into maximize sum(scen in Scenarios)
(<Expr[scen]>)*Probability[scen]
Another important objective function type, Markowitz's mean/variance model, **mv(<Expr>,**λ) or E{Q} + λE{K}**, which takes into account the tradeoff between the expected value of an objective**
function and its variability, can easily be expressed in the **certainty equivalent form by employing the** absolute deviation function of Sec.4.3:
minimize expected(Q) + λ***expected(K)**
subject to {
K - Q + expected(Q) ≥ 0; K + Q - expected(Q) ≥ 0; ... };
Other objective functions, namely, minimize spread(profit) maximize downside(profit) minimize upside(cost)
which are supported by Stochastic OPL are compiled in a similar fashion.

This is by no means an exhaustive list but it gives an indication of the variety of optimization goals and the versatility of the Stochastic OPL system. New optimization goals can be incorporated into the system as needed.

## 6 Value Of Information And Stochastic Solutions

We can also easily provide the user with information about how much value is obtained if we were to know the value of stochastic variables. For example, in some **situations it can be possible to wait for**
11